using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Reflection;

namespace BatteryDemo
{
	/// <summary>
	/// Summary description for frmMain.
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button cmdClose;
		internal System.Windows.Forms.Button cmdBattery;
		internal System.Windows.Forms.Label lblBattery;
	
		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		static void Main() 
		{
			try
			{
				Application.Run(new frmMain());
			}											
			catch
			{
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdClose = new System.Windows.Forms.Button();
			this.cmdBattery = new System.Windows.Forms.Button();
			this.lblBattery = new System.Windows.Forms.Label();
			// 
			// cmdClose
			// 
			this.cmdClose.Location = new System.Drawing.Point(136, 224);
			this.cmdClose.Size = new System.Drawing.Size(80, 24);
			this.cmdClose.Text = "Close";
			this.cmdClose.Click += new System.EventHandler(this.cmdClose_Click);
			// 
			// cmdBattery
			// 
			this.cmdBattery.Location = new System.Drawing.Point(56, 120);
			this.cmdBattery.Size = new System.Drawing.Size(144, 48);
			this.cmdBattery.Text = "Check Battery";
			this.cmdBattery.Click += new System.EventHandler(this.cmdBattery_Click);
			// 
			// lblBattery
			// 
			this.lblBattery.ForeColor = System.Drawing.SystemColors.ControlText;
			this.lblBattery.Location = new System.Drawing.Point(16, 56);
			this.lblBattery.Size = new System.Drawing.Size(216, 32);
			this.lblBattery.Text = "Battery Status";
			// 
			// frmMain
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.cmdClose);
			this.Controls.Add(this.cmdBattery);
			this.Controls.Add(this.lblBattery);
			this.Text = "Battery Demo";
			this.Load += new System.EventHandler(this.frmMain_Load);

		}
		#endregion

		private void frmMain_Load(object sender, System.EventArgs e)
		{
			// Make sure the DLL(s) are in the same directory as the program for C#
			FileInfo fsBattery = new FileInfo(Path.GetDirectoryName(Assembly.GetExecutingAssembly().GetModules()[0].FullyQualifiedName) + "\\SapphireBattery.DLL");
			if (fsBattery.Exists == false)
			{
				cmdBattery.Enabled = false;
				lblBattery.Text = "SapphireBattery.DLL missing";
				lblBattery.Update();
			}
		}

		private void cmdClose_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void cmdBattery_Click(object sender, System.EventArgs e)
		{
			int iPercent;

			iPercent = clsBattery.BatteryPercent();
			if (iPercent == 255)
				lblBattery.Text = "Battery Charging....";
			else
				lblBattery.Text = "Battery level is " + clsBattery.BatteryPercent() + " %";
			if (iPercent >= 50)
				lblBattery.ForeColor = Color.Green;
			if (iPercent < 50)
				lblBattery.ForeColor = Color.Yellow;
			if (iPercent < 30)
				lblBattery.ForeColor = Color.Red;
			lblBattery.Update();
		}
	}
}
