Imports System.IO
Imports System.Reflection

Public Class frmMain
    Inherits System.Windows.Forms.Form
    Friend WithEvents cmdIMEI As System.Windows.Forms.Button
    Friend WithEvents cmdClose As System.Windows.Forms.Button
    Friend WithEvents lblIMEI As System.Windows.Forms.Label

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        MyBase.Dispose(disposing)
    End Sub

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents lblDeviceID As System.Windows.Forms.Label
    Friend WithEvents cmdIMSI As System.Windows.Forms.Button
    Friend WithEvents cmdOn As System.Windows.Forms.Button
    Friend WithEvents cmdOff As System.Windows.Forms.Button
    Friend WithEvents lblFlightMode As System.Windows.Forms.Label
    Friend WithEvents txtDeviceID As System.Windows.Forms.TextBox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents InputPanel1 As Microsoft.WindowsCE.Forms.InputPanel
    Private Sub InitializeComponent()
        Me.cmdIMEI = New System.Windows.Forms.Button
        Me.cmdClose = New System.Windows.Forms.Button
        Me.lblIMEI = New System.Windows.Forms.Label
        Me.lblDeviceID = New System.Windows.Forms.Label
        Me.cmdIMSI = New System.Windows.Forms.Button
        Me.cmdOn = New System.Windows.Forms.Button
        Me.cmdOff = New System.Windows.Forms.Button
        Me.lblFlightMode = New System.Windows.Forms.Label
        Me.txtDeviceID = New System.Windows.Forms.TextBox
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.InputPanel1 = New Microsoft.WindowsCE.Forms.InputPanel
        '
        'cmdIMEI
        '
        Me.cmdIMEI.Location = New System.Drawing.Point(80, 24)
        Me.cmdIMEI.Size = New System.Drawing.Size(88, 24)
        Me.cmdIMEI.Text = "IMEI"
        '
        'cmdClose
        '
        Me.cmdClose.Location = New System.Drawing.Point(80, 224)
        Me.cmdClose.Size = New System.Drawing.Size(88, 24)
        Me.cmdClose.Text = "Close"
        '
        'lblIMEI
        '
        Me.lblIMEI.Location = New System.Drawing.Point(8, 136)
        Me.lblIMEI.Size = New System.Drawing.Size(224, 16)
        Me.lblIMEI.Text = "IMEI Number is"
        '
        'lblDeviceID
        '
        Me.lblDeviceID.Location = New System.Drawing.Point(8, 108)
        Me.lblDeviceID.Size = New System.Drawing.Size(72, 16)
        Me.lblDeviceID.Text = "Device ID is"
        '
        'cmdIMSI
        '
        Me.cmdIMSI.Location = New System.Drawing.Point(80, 64)
        Me.cmdIMSI.Size = New System.Drawing.Size(88, 24)
        Me.cmdIMSI.Text = "IMSI"
        '
        'cmdOn
        '
        Me.cmdOn.Location = New System.Drawing.Point(48, 192)
        Me.cmdOn.Size = New System.Drawing.Size(72, 24)
        Me.cmdOn.Text = "Turn On"
        '
        'cmdOff
        '
        Me.cmdOff.Location = New System.Drawing.Point(136, 192)
        Me.cmdOff.Size = New System.Drawing.Size(72, 24)
        Me.cmdOff.Text = "Turn Off"
        '
        'lblFlightMode
        '
        Me.lblFlightMode.Location = New System.Drawing.Point(48, 176)
        Me.lblFlightMode.Size = New System.Drawing.Size(160, 16)
        Me.lblFlightMode.Text = "Set Flight Mode"
        Me.lblFlightMode.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'txtDeviceID
        '
        Me.txtDeviceID.Location = New System.Drawing.Point(80, 104)
        Me.txtDeviceID.Size = New System.Drawing.Size(88, 20)
        Me.txtDeviceID.Text = ""
        '
        'frmMain
        '
        Me.BackColor = System.Drawing.Color.Aqua
        Me.Controls.Add(Me.txtDeviceID)
        Me.Controls.Add(Me.lblFlightMode)
        Me.Controls.Add(Me.cmdOff)
        Me.Controls.Add(Me.cmdOn)
        Me.Controls.Add(Me.cmdIMSI)
        Me.Controls.Add(Me.lblDeviceID)
        Me.Controls.Add(Me.lblIMEI)
        Me.Controls.Add(Me.cmdClose)
        Me.Controls.Add(Me.cmdIMEI)
        Me.Menu = Me.MainMenu1
        Me.Text = "IMEI Demo"

    End Sub

#End Region

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Make sure the DLL(s) are in the same directory as the program for VB.NET
        Dim fsIMEI As New FileInfo(Path.GetDirectoryName([Assembly].GetExecutingAssembly().GetModules(0).FullyQualifiedName) & "\SapphireIMEI.DLL")
        If fsIMEI.Exists() = False Then
            cmdIMEI.Enabled = False
            cmdIMSI.Enabled = False
            lblIMEI.Text = "SapphireIMEI.DLL missing"
            lblIMEI.Update()
        End If
    End Sub

    Private Sub cmdClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClose.Click
        Application.Exit()
    End Sub

    Private Sub cmdIMEI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdIMEI.Click
        Dim sIMEI As String
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            txtDeviceID.Text = iDeviceID
            sIMEI = IMEI(iDeviceID)
            If Len(sIMEI) >= 15 Then
                sIMEI = Mid(sIMEI, 1, 15)
                lblIMEI.Text = "IMEI Number is " & sIMEI
                lblIMEI.Update()
                Exit For
            End If
        Next iDeviceID
    End Sub

    Private Sub cmdIMSI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdIMSI.Click
        Dim sIMSI As String
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            txtDeviceID.Text = iDeviceID
            sIMSI = IMSI(iDeviceID)
            If Len(sIMSI) >= 15 Then
                sIMSI = Mid(sIMSI, 1, 15)
                lblIMEI.Text = "IMSI Number is " & sIMSI
                lblIMEI.Update()
                Exit For
            End If
        Next iDeviceID
    End Sub

    Private Sub cmdOn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdOn.Click
        If txtDeviceID.Text = "" Then
            MsgBox("Enter a device ID")
        Else
            FlightMode(CInt(txtDeviceID.Text), 1)
        End If
    End Sub

    Private Sub cmdOff_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdOff.Click
        If txtDeviceID.Text = "" Then
            MsgBox("Enter a device ID")
        Else
            FlightMode(CInt(txtDeviceID.Text), 0)
        End If
    End Sub
End Class
