using System;
using System.IO;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Reflection;

namespace IMEIDemo
{
	/// <summary>
	/// Summary description for frmMain.
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button cmdIMSI;
		internal System.Windows.Forms.Label lblDeviceID;
		internal System.Windows.Forms.Label lblIMEI;
		internal System.Windows.Forms.Button cmdClose;
		internal System.Windows.Forms.Label lblFlightMode;
		internal System.Windows.Forms.Button cmdOff;
		internal System.Windows.Forms.Button cmdOn;
		internal System.Windows.Forms.Button cmdIMEI;
	
		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		static void Main() 
		{
			try
			{
				Application.Run(new frmMain());
			}											
			catch
			{
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdIMSI = new System.Windows.Forms.Button();
			this.lblDeviceID = new System.Windows.Forms.Label();
			this.lblIMEI = new System.Windows.Forms.Label();
			this.cmdClose = new System.Windows.Forms.Button();
			this.cmdIMEI = new System.Windows.Forms.Button();
			this.lblFlightMode = new System.Windows.Forms.Label();
			this.cmdOff = new System.Windows.Forms.Button();
			this.cmdOn = new System.Windows.Forms.Button();
			// 
			// cmdIMSI
			// 
			this.cmdIMSI.Location = new System.Drawing.Point(80, 72);
			this.cmdIMSI.Size = new System.Drawing.Size(88, 24);
			this.cmdIMSI.Text = "IMSI";
			this.cmdIMSI.Click += new System.EventHandler(this.cmdIMSI_Click);
			// 
			// lblDeviceID
			// 
			this.lblDeviceID.Location = new System.Drawing.Point(8, 104);
			this.lblDeviceID.Size = new System.Drawing.Size(224, 16);
			this.lblDeviceID.Text = "Device ID is";
			// 
			// lblIMEI
			// 
			this.lblIMEI.Location = new System.Drawing.Point(8, 136);
			this.lblIMEI.Size = new System.Drawing.Size(224, 16);
			this.lblIMEI.Text = "IMEI Number is";
			// 
			// cmdClose
			// 
			this.cmdClose.Location = new System.Drawing.Point(80, 224);
			this.cmdClose.Size = new System.Drawing.Size(88, 24);
			this.cmdClose.Text = "Close";
			this.cmdClose.Click += new System.EventHandler(this.cmdClose_Click);
			// 
			// cmdIMEI
			// 
			this.cmdIMEI.Location = new System.Drawing.Point(80, 32);
			this.cmdIMEI.Size = new System.Drawing.Size(88, 24);
			this.cmdIMEI.Text = "IMEI";
			this.cmdIMEI.Click += new System.EventHandler(this.cmdIMEI_Click);
			// 
			// lblFlightMode
			// 
			this.lblFlightMode.Location = new System.Drawing.Point(40, 168);
			this.lblFlightMode.Size = new System.Drawing.Size(160, 16);
			this.lblFlightMode.Text = "Set Flight Mode";
			this.lblFlightMode.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// cmdOff
			// 
			this.cmdOff.Location = new System.Drawing.Point(128, 184);
			this.cmdOff.Size = new System.Drawing.Size(72, 24);
			this.cmdOff.Text = "Turn Off";
			this.cmdOff.Click += new System.EventHandler(this.cmdOff_Click);
			// 
			// cmdOn
			// 
			this.cmdOn.Location = new System.Drawing.Point(40, 184);
			this.cmdOn.Size = new System.Drawing.Size(72, 24);
			this.cmdOn.Text = "Turn On";
			this.cmdOn.Click += new System.EventHandler(this.cmdOn_Click);
			// 
			// frmMain
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.lblFlightMode);
			this.Controls.Add(this.cmdOff);
			this.Controls.Add(this.cmdOn);
			this.Controls.Add(this.cmdIMSI);
			this.Controls.Add(this.lblDeviceID);
			this.Controls.Add(this.lblIMEI);
			this.Controls.Add(this.cmdClose);
			this.Controls.Add(this.cmdIMEI);
			this.Text = "IMEI Demo";
			this.Load += new System.EventHandler(this.frmMain_Load);

		}
		#endregion

		private void frmMain_Load(object sender, System.EventArgs e)
		{
			// Make sure the DLL(s) are in the same directory as the program for C#
			FileInfo fsIMEI = new FileInfo(Path.GetDirectoryName(Assembly.GetExecutingAssembly().GetModules()[0].FullyQualifiedName) + "\\SapphireIMEI.DLL");
			if (fsIMEI.Exists == false)
			{
				cmdIMEI.Enabled = false;
				cmdIMSI.Enabled = false;
				lblIMEI.Text = "SapphireIMEI.DLL missing";
				lblIMEI.Update();
			}
		}

		private void cmdClose_Click(object sender, System.EventArgs e)
		{
			Application.Exit();
		}

		private void cmdIMEI_Click(object sender, System.EventArgs e)
		{
			string sIMEI;
			int iDeviceID;

			// Cycles through all devices, alternatively set DeviceID to a fixed ID
			for (iDeviceID = 0; iDeviceID <= 10; iDeviceID++)
			{
				lblDeviceID.Text = "Device ID is " + iDeviceID;
				lblDeviceID.Update();
				sIMEI = clsIMEI.IMEI(iDeviceID);
				if (sIMEI.Length >= 15)
				{
					sIMEI = sIMEI.Substring(0, 15);
					lblIMEI.Text = "IMEI Number is " + sIMEI;
					lblIMEI.Update();
					return;
				}
			}
		}

		private void cmdIMSI_Click(object sender, System.EventArgs e)
		{
			string sIMSI;
			int iDeviceID;

			// Cycles through all devices, alternatively set DeviceID to a fixed ID
			for (iDeviceID = 0; iDeviceID <= 10; iDeviceID++)
			{
				lblDeviceID.Text = "Device ID is " + iDeviceID;
				lblDeviceID.Update();
				sIMSI = clsIMEI.IMSI(iDeviceID);
				if (sIMSI.Length >= 15)
				{
					sIMSI = sIMSI.Substring(0, 15);
					lblIMEI.Text = "IMSI Number is " + sIMSI;
					lblIMEI.Update();
					return;
				}
			}
		}

		private void cmdOn_Click(object sender, System.EventArgs e)
		{
			int iDeviceID;

			// Cycles through all devices, alternatively set DeviceID to a fixed ID
			for (iDeviceID = 0; iDeviceID <= 10; iDeviceID++)
			{
				clsIMEI.FlightMode(iDeviceID, 1);
			}
		}

		private void cmdOff_Click(object sender, System.EventArgs e)
		{
			int iDeviceID;

			// Cycles through all devices, alternatively set DeviceID to a fixed ID
			for (iDeviceID = 0; iDeviceID <= 10; iDeviceID++)
			{
				clsIMEI.FlightMode(iDeviceID, 0);
			}
		}
	}
}
