Imports System.IO
Imports System.Reflection

Public Class frmMain
    Inherits System.Windows.Forms.Form
    Friend WithEvents cmdIMEI As System.Windows.Forms.Button
    Friend WithEvents cmdClose As System.Windows.Forms.Button
    Friend WithEvents cmdDeviceID As System.Windows.Forms.Button
    Friend WithEvents lblIMEI As System.Windows.Forms.Label

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        MyBase.Dispose(disposing)
    End Sub

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents lblDeviceID As System.Windows.Forms.Label
    Friend WithEvents cmdIMSI As System.Windows.Forms.Button
    Friend WithEvents cmdOn As System.Windows.Forms.Button
    Friend WithEvents cmdOff As System.Windows.Forms.Button
    Friend WithEvents lblFlightMode As System.Windows.Forms.Label
    Friend WithEvents txtDeviceID As System.Windows.Forms.TextBox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents InputPanel1 As Microsoft.WindowsCE.Forms.InputPanel
    Private Sub InitializeComponent()
        Me.cmdIMEI = New System.Windows.Forms.Button
        Me.cmdClose = New System.Windows.Forms.Button
        Me.lblIMEI = New System.Windows.Forms.Label
        Me.lblDeviceID = New System.Windows.Forms.Label
        Me.cmdIMSI = New System.Windows.Forms.Button
        Me.cmdOn = New System.Windows.Forms.Button
        Me.cmdOff = New System.Windows.Forms.Button
        Me.lblFlightMode = New System.Windows.Forms.Label
        Me.txtDeviceID = New System.Windows.Forms.TextBox
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.InputPanel1 = New Microsoft.WindowsCE.Forms.InputPanel
        Me.cmdDeviceID = New System.Windows.Forms.Button
        Me.SuspendLayout()
        '
        'cmdIMEI
        '
        Me.cmdIMEI.Location = New System.Drawing.Point(80, 14)
        Me.cmdIMEI.Name = "cmdIMEI"
        Me.cmdIMEI.Size = New System.Drawing.Size(88, 24)
        Me.cmdIMEI.TabIndex = 8
        Me.cmdIMEI.Text = "IMEI"
        '
        'cmdClose
        '
        Me.cmdClose.Location = New System.Drawing.Point(80, 224)
        Me.cmdClose.Name = "cmdClose"
        Me.cmdClose.Size = New System.Drawing.Size(88, 24)
        Me.cmdClose.TabIndex = 7
        Me.cmdClose.Text = "Close"
        '
        'lblIMEI
        '
        Me.lblIMEI.Location = New System.Drawing.Point(8, 136)
        Me.lblIMEI.Name = "lblIMEI"
        Me.lblIMEI.Size = New System.Drawing.Size(224, 16)
        Me.lblIMEI.Text = "IMEI Number is"
        '
        'lblDeviceID
        '
        Me.lblDeviceID.Location = New System.Drawing.Point(8, 108)
        Me.lblDeviceID.Name = "lblDeviceID"
        Me.lblDeviceID.Size = New System.Drawing.Size(72, 16)
        Me.lblDeviceID.Text = "Device ID is"
        '
        'cmdIMSI
        '
        Me.cmdIMSI.Location = New System.Drawing.Point(80, 44)
        Me.cmdIMSI.Name = "cmdIMSI"
        Me.cmdIMSI.Size = New System.Drawing.Size(88, 24)
        Me.cmdIMSI.TabIndex = 4
        Me.cmdIMSI.Text = "IMSI"
        '
        'cmdOn
        '
        Me.cmdOn.Location = New System.Drawing.Point(48, 192)
        Me.cmdOn.Name = "cmdOn"
        Me.cmdOn.Size = New System.Drawing.Size(72, 24)
        Me.cmdOn.TabIndex = 3
        Me.cmdOn.Text = "Turn On"
        '
        'cmdOff
        '
        Me.cmdOff.Location = New System.Drawing.Point(136, 192)
        Me.cmdOff.Name = "cmdOff"
        Me.cmdOff.Size = New System.Drawing.Size(72, 24)
        Me.cmdOff.TabIndex = 2
        Me.cmdOff.Text = "Turn Off"
        '
        'lblFlightMode
        '
        Me.lblFlightMode.Location = New System.Drawing.Point(48, 176)
        Me.lblFlightMode.Name = "lblFlightMode"
        Me.lblFlightMode.Size = New System.Drawing.Size(160, 16)
        Me.lblFlightMode.Text = "Set Flight Mode"
        Me.lblFlightMode.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'txtDeviceID
        '
        Me.txtDeviceID.Location = New System.Drawing.Point(80, 104)
        Me.txtDeviceID.Name = "txtDeviceID"
        Me.txtDeviceID.Size = New System.Drawing.Size(88, 21)
        Me.txtDeviceID.TabIndex = 0
        '
        'cmdDeviceID
        '
        Me.cmdDeviceID.Location = New System.Drawing.Point(80, 74)
        Me.cmdDeviceID.Name = "cmdDeviceID"
        Me.cmdDeviceID.Size = New System.Drawing.Size(88, 24)
        Me.cmdDeviceID.TabIndex = 9
        Me.cmdDeviceID.Text = "DeviceID"
        '
        'frmMain
        '
        Me.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Inherit
        Me.BackColor = System.Drawing.Color.Aqua
        Me.ClientSize = New System.Drawing.Size(240, 268)
        Me.Controls.Add(Me.cmdDeviceID)
        Me.Controls.Add(Me.txtDeviceID)
        Me.Controls.Add(Me.lblFlightMode)
        Me.Controls.Add(Me.cmdOff)
        Me.Controls.Add(Me.cmdOn)
        Me.Controls.Add(Me.cmdIMSI)
        Me.Controls.Add(Me.lblDeviceID)
        Me.Controls.Add(Me.lblIMEI)
        Me.Controls.Add(Me.cmdClose)
        Me.Controls.Add(Me.cmdIMEI)
        Me.Menu = Me.MainMenu1
        Me.Name = "frmMain"
        Me.Text = "IMEI Demo"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Make sure the DLL(s) are in the same directory as the program for VB.NET
        Dim fsIMEI As New FileInfo(Path.GetDirectoryName([Assembly].GetExecutingAssembly().GetModules(0).FullyQualifiedName) & "\SapphireIMEI.DLL")
        If fsIMEI.Exists() = False Then
            cmdIMEI.Enabled = False
            cmdIMSI.Enabled = False
            lblIMEI.Text = "SapphireIMEI.DLL missing"
            lblIMEI.Update()
        End If
    End Sub

    Private Sub cmdClose_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdClose.Click
        Application.Exit()
    End Sub

    Private Sub cmdIMEI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdIMEI.Click
        Dim sIMEI As String
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            txtDeviceID.Text = CStr(iDeviceID)
            sIMEI = IMEI(iDeviceID)
            If Len(sIMEI) >= 15 Then
                sIMEI = Mid(sIMEI, 1, 15)
                lblIMEI.Text = "IMEI Number is " & sIMEI
                lblIMEI.Update()
                Exit For
            End If
        Next iDeviceID
    End Sub

    Private Sub cmdIMSI_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdIMSI.Click
        Dim sIMSI As String
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            txtDeviceID.Text = CStr(iDeviceID)
            sIMSI = IMSI(iDeviceID)
            If Len(sIMSI) >= 15 Then
                sIMSI = Mid(sIMSI, 1, 15)
                lblIMEI.Text = "IMSI Number is " & sIMSI
                lblIMEI.Update()
                Exit For
            End If
        Next iDeviceID
    End Sub

    Private Sub cmdOn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdOn.Click
        If txtDeviceID.Text = "" Then
            MsgBox("Enter a device ID")
        Else
            FlightMode(CInt(txtDeviceID.Text), 1)
        End If
    End Sub

    Private Sub cmdOff_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdOff.Click
        If txtDeviceID.Text = "" Then
            MsgBox("Enter a device ID")
        Else
            FlightMode(CInt(txtDeviceID.Text), 0)
        End If
    End Sub

    Private Sub cmdDeviceID_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDeviceID.Click
        MsgBox(wmDeviceID()) ' Only works on WM5 or above
        MsgBox(ppcDeviceID())
    End Sub
End Class
