Imports System.IO
Imports System.Reflection

Public Class frmMain
    Inherits System.Windows.Forms.Form
    Friend WithEvents menuExit As System.Windows.Forms.MenuItem
    Friend WithEvents txtDeviceId As System.Windows.Forms.TextBox
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        MyBase.Dispose(disposing)
    End Sub

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents txtIMEI As System.Windows.Forms.TextBox
    Friend WithEvents lblDeviceID As System.Windows.Forms.Label
    Friend WithEvents lblIMEI As System.Windows.Forms.Label
    Friend WithEvents txtFlightOn As System.Windows.Forms.TextBox
    Friend WithEvents txtFlightOff As System.Windows.Forms.TextBox
    Friend WithEvents txtIMSI As System.Windows.Forms.TextBox
    Private Sub InitializeComponent()
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.menuExit = New System.Windows.Forms.MenuItem
        Me.txtIMEI = New System.Windows.Forms.TextBox
        Me.lblDeviceID = New System.Windows.Forms.Label
        Me.lblIMEI = New System.Windows.Forms.Label
        Me.txtFlightOn = New System.Windows.Forms.TextBox
        Me.txtFlightOff = New System.Windows.Forms.TextBox
        Me.txtIMSI = New System.Windows.Forms.TextBox
        Me.txtDeviceId = New System.Windows.Forms.TextBox
        Me.SuspendLayout()
        '
        'MainMenu1
        '
        Me.MainMenu1.MenuItems.Add(Me.menuExit)
        '
        'menuExit
        '
        Me.menuExit.Text = "Exit"
        '
        'txtIMEI
        '
        Me.txtIMEI.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Bold)
        Me.txtIMEI.Location = New System.Drawing.Point(32, 3)
        Me.txtIMEI.Name = "txtIMEI"
        Me.txtIMEI.Size = New System.Drawing.Size(112, 21)
        Me.txtIMEI.TabIndex = 0
        Me.txtIMEI.Text = "IMEI Number"
        '
        'lblDeviceID
        '
        Me.lblDeviceID.Location = New System.Drawing.Point(-3, 80)
        Me.lblDeviceID.Name = "lblDeviceID"
        Me.lblDeviceID.Size = New System.Drawing.Size(176, 16)
        Me.lblDeviceID.Text = "Device ID is"
        '
        'lblIMEI
        '
        Me.lblIMEI.Location = New System.Drawing.Point(0, 96)
        Me.lblIMEI.Name = "lblIMEI"
        Me.lblIMEI.Size = New System.Drawing.Size(176, 16)
        Me.lblIMEI.Text = "IMEI is"
        '
        'txtFlightOn
        '
        Me.txtFlightOn.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Bold)
        Me.txtFlightOn.Location = New System.Drawing.Point(32, 120)
        Me.txtFlightOn.Name = "txtFlightOn"
        Me.txtFlightOn.Size = New System.Drawing.Size(112, 21)
        Me.txtFlightOn.TabIndex = 2
        Me.txtFlightOn.Text = "Flight Mode On"
        '
        'txtFlightOff
        '
        Me.txtFlightOff.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Bold)
        Me.txtFlightOff.Location = New System.Drawing.Point(32, 152)
        Me.txtFlightOff.Name = "txtFlightOff"
        Me.txtFlightOff.Size = New System.Drawing.Size(112, 21)
        Me.txtFlightOff.TabIndex = 3
        Me.txtFlightOff.Text = "Flight Mode Off"
        '
        'txtIMSI
        '
        Me.txtIMSI.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Bold)
        Me.txtIMSI.Location = New System.Drawing.Point(32, 30)
        Me.txtIMSI.Name = "txtIMSI"
        Me.txtIMSI.Size = New System.Drawing.Size(112, 21)
        Me.txtIMSI.TabIndex = 1
        Me.txtIMSI.Text = "IMSI Number"
        '
        'txtDeviceId
        '
        Me.txtDeviceId.Font = New System.Drawing.Font("Microsoft Sans Serif", 9.75!, System.Drawing.FontStyle.Bold)
        Me.txtDeviceId.Location = New System.Drawing.Point(32, 57)
        Me.txtDeviceId.Name = "txtDeviceId"
        Me.txtDeviceId.Size = New System.Drawing.Size(112, 21)
        Me.txtDeviceId.TabIndex = 6
        Me.txtDeviceId.Text = "Device ID"
        '
        'frmMain
        '
        Me.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Inherit
        Me.BackColor = System.Drawing.Color.Aqua
        Me.ClientSize = New System.Drawing.Size(176, 180)
        Me.Controls.Add(Me.txtDeviceId)
        Me.Controls.Add(Me.txtIMEI)
        Me.Controls.Add(Me.txtIMSI)
        Me.Controls.Add(Me.txtFlightOn)
        Me.Controls.Add(Me.txtFlightOff)
        Me.Controls.Add(Me.lblIMEI)
        Me.Controls.Add(Me.lblDeviceID)
        Me.Menu = Me.MainMenu1
        Me.Name = "frmMain"
        Me.Text = "IMEI Demo"
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub menuExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles menuExit.Click
        Application.Exit()
    End Sub

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Make sure the DLL(s) are in the same directory as the program for VB.NET
        Dim fsIMEI As New FileInfo(Path.GetDirectoryName([Assembly].GetExecutingAssembly().GetModules(0).FullyQualifiedName) & "\SapphireIMEI.DLL")
        If fsIMEI.Exists() = False Then
            txtIMEI.Enabled = False
            txtIMSI.Enabled = False
            txtFlightOn.Enabled = False
            txtFlightOff.Enabled = False
            lblIMEI.Text = "SapphireIMEI.DLL missing"
            lblIMEI.Update()
        End If
    End Sub

    Private Sub txtIMEI_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtIMEI.KeyPress
        Dim sIMEI As String
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            lblDeviceID.Text = "Device ID is " & iDeviceID
            lblDeviceID.Update()
            sIMEI = IMEI(iDeviceID)
            If Len(sIMEI) >= 15 Then
                sIMEI = Mid(sIMEI, 1, 15)
                lblIMEI.Text = "IMEI is " & sIMEI
                lblIMEI.Update()
                Exit For
            End If
        Next iDeviceID
    End Sub

    Private Sub txtFlightOn_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtFlightOn.KeyPress
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            FlightMode(iDeviceID, 1)
        Next iDeviceID
    End Sub

    Private Sub txtFlightOff_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtFlightOff.KeyPress
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            FlightMode(iDeviceID, 0)
        Next iDeviceID
    End Sub

    Private Sub txtIMSI_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtIMSI.KeyPress
        Dim sIMSI As String
        Dim iDeviceID As Integer

        ' Cycles through all devices, alternatively set DeviceID to a fixed ID
        For iDeviceID = 0 To 10
            lblDeviceID.Text = "Device ID is " & iDeviceID
            lblDeviceID.Update()
            sIMSI = IMSI(iDeviceID)
            If Len(sIMSI) >= 15 Then
                sIMSI = Mid(sIMSI, 1, 15)
                lblIMEI.Text = "IMSI is " & sIMSI
                lblIMEI.Update()
                Exit For
            End If
        Next iDeviceID
    End Sub

    Private Sub txtDeviceId_KeyPress(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles txtDeviceId.KeyPress
        MsgBox(wmDeviceID()) ' Only works on WM5 or above
        MsgBox(ppcDeviceID())
    End Sub
End Class
