using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace RASDemo
{
	/// <summary>
	/// Summary description for clsLocation.
	/// </summary>
	public class clsLocation
	{
		[DllImport("SapphireRAS.dll")]
		public static extern int sLOCGetCurrent();

		[DllImport("SapphireRAS.dll")]
		public static extern int sLOCSetCurrent(int iNumber);

		[DllImport("SapphireRAS.dll")]
		public static extern int sLOCGetNumber();

		[DllImport("SapphireRAS.dll")]
		public static extern int sLOCSetNumber(int iNumber);

		[DllImport("SapphireRAS.dll")]
		public static extern int sLOCGetLocation(int iNumber, string sLocations);

		[DllImport("SapphireRAS.dll")]
		public static extern int sLOCSetLocation(int iNumber, string sSettings);

		[DllImport("SapphireRAS.dll")]
		public static extern int sLOCDeleteLocation(int iNumber);


		public clsLocation()
		{
		}

		public static int LOCGetCurrent()
		{
			return sLOCGetCurrent();
		}

		public static int LOCSetCurrent(int iNumber)
		{
			return sLOCSetCurrent(iNumber);
		}

		public static int LOCGetNumber()
		{
			return sLOCGetNumber();
		}

		public static int LOCSetNumber(int iNumber)
		{
			return sLOCSetNumber(iNumber);
		}

		public static string LOCGetLocation(int iNumber)
		{
			string sLocations = new String(' ',2048);
			sLOCGetLocation(iNumber, sLocations);
			sLocations = sLocations.TrimEnd(' ');
			sLocations = sLocations.TrimEnd(Convert.ToChar(0x0000));
			return sLocations;
		}


		public static int LOCSetLocation(int iNumber, string sName, string sLocal, string sLong, string sInternational, string sArea, string sCountry)
		{
			string sSettings;
			string sCallWaiting;
			string sTone;

			sCallWaiting = ""; // Call Waiting disable string
			sTone = "0"; // 0 = Tone Dialling ; 1 = Pulse Dialling
			sSettings = sName + "|" + sLocal + "|" + sLong + "|" + sInternational + "|" + sArea + "|" + sCallWaiting + "|" + sCountry + "|" + sTone + "|";
			return sLOCSetLocation(iNumber, sSettings);
		}

		public static int LOCDeleteLocation(int iNumber)
		{
			return sLOCDeleteLocation(iNumber);
		}

		public static void RefreshLocations()
		{
			string sEntry;
			int iNumber;
			int iCount;

			iNumber = LOCGetNumber();
			clsListItem [] oComboName = new clsListItem[iNumber];
			clsMain.fSetLocation.cboName.Items.Clear();
			clsMain.fSetLocation.cboName.DisplayMember = "sText";
			clsMain.fSetLocation.cboName.ValueMember = "iValue";

			for (iCount = 0; iCount < iNumber; iCount++)
			{
				sEntry = LOCGetLocation(iCount);
				string [] sEntries = sEntry.Split('|');
				if (sEntries.GetUpperBound(0) > 0)
				{
					oComboName[iCount] = new clsListItem();
					oComboName[iCount].iValue = iCount;
					oComboName[iCount].sText = sEntries[0];
					clsMain.fSetLocation.cboName.Items.Add(oComboName[iCount]);
				}
			}
		}

		public static void SetLOCName(int iNumber)
		{
			string sEntry;
			int iCount;

			sEntry = LOCGetLocation(iNumber);
			string [] sEntries = sEntry.Split('|');
			if (sEntries.GetUpperBound(0) > 0)
			{
				for (iCount = 0; iCount < clsMain.fSetLocation.cboName.Items.Count; iCount++)
				{
					clsListItem oComboName = (clsListItem)clsMain.fSetLocation.cboName.Items[iCount];
					if (oComboName.iValue == iNumber)
					{
						clsMain.fSetLocation.cboName.SelectedItem = clsMain.fSetLocation.cboName.Items[iCount];
						break;
					}
				}
			}
		}

		public static void SetLOCValues(int iNumber)
		{
			string sEntry;

			sEntry = LOCGetLocation(iNumber);
			string [] sEntries = sEntry.Split('|');
			if (sEntries.GetUpperBound(0) > 0)
			{
				clsMain.fSetLocation.txtName.Text = sEntries[0];
				clsMain.fSetLocation.txtLocal.Text = sEntries[1];
				clsMain.fSetLocation.txtLong.Text = sEntries[2];
				clsMain.fSetLocation.txtInternational.Text = sEntries[3];
				clsMain.fSetLocation.txtArea.Text = sEntries[4];
				// sEntries(5) ' Disable Call Waiting disable string
				clsMain.fSetLocation.txtCountry.Text = sEntries[6];
				// sEntries(7) ' 0 for Tone Dialing ; 1 for Pulse Dialing
			}
		}
	}
}
