using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace RASDemo
{
	/// <summary>
	/// Summary description for frmSetLocation.
	/// </summary>
	public class frmSetLocation : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.TextBox txtName;
		internal System.Windows.Forms.Label lblName;
		internal System.Windows.Forms.Label lblCurrent;
		internal System.Windows.Forms.Button cmdSaveEntry;
		internal System.Windows.Forms.TextBox txtLocal;
		internal System.Windows.Forms.TextBox txtInternational;
		internal System.Windows.Forms.Label lblLong;
		internal System.Windows.Forms.TextBox txtArea;
		internal System.Windows.Forms.Button cmdBack;
		internal System.Windows.Forms.ComboBox cboName;
		internal System.Windows.Forms.Button cmdCurrent;
		internal System.Windows.Forms.Label lblLocal;
		internal System.Windows.Forms.Label lblCountry;
		internal System.Windows.Forms.Label lblLocs;
		internal System.Windows.Forms.Button cmdNewEntry;
		internal System.Windows.Forms.Button cmdDelete;
		internal System.Windows.Forms.Label lblInternational;
		internal System.Windows.Forms.Label lblArea;
		internal System.Windows.Forms.Label lblText;
		internal System.Windows.Forms.TextBox txtCountry;
		private System.Windows.Forms.MainMenu mainMenu1;
		private Microsoft.WindowsCE.Forms.InputPanel inputPanel1;
		internal System.Windows.Forms.TextBox txtLong;
	
		public frmSetLocation()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblName = new System.Windows.Forms.Label();
			this.lblCurrent = new System.Windows.Forms.Label();
			this.cmdSaveEntry = new System.Windows.Forms.Button();
			this.txtLocal = new System.Windows.Forms.TextBox();
			this.txtInternational = new System.Windows.Forms.TextBox();
			this.lblLong = new System.Windows.Forms.Label();
			this.txtArea = new System.Windows.Forms.TextBox();
			this.cmdBack = new System.Windows.Forms.Button();
			this.cboName = new System.Windows.Forms.ComboBox();
			this.cmdCurrent = new System.Windows.Forms.Button();
			this.lblLocal = new System.Windows.Forms.Label();
			this.lblCountry = new System.Windows.Forms.Label();
			this.lblLocs = new System.Windows.Forms.Label();
			this.cmdNewEntry = new System.Windows.Forms.Button();
			this.cmdDelete = new System.Windows.Forms.Button();
			this.lblInternational = new System.Windows.Forms.Label();
			this.lblArea = new System.Windows.Forms.Label();
			this.lblText = new System.Windows.Forms.Label();
			this.txtCountry = new System.Windows.Forms.TextBox();
			this.txtLong = new System.Windows.Forms.TextBox();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.inputPanel1 = new Microsoft.WindowsCE.Forms.InputPanel();
			// 
			// txtName
			// 
			this.txtName.Location = new System.Drawing.Point(96, 32);
			this.txtName.Size = new System.Drawing.Size(136, 20);
			this.txtName.Text = "";
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 32);
			this.lblName.Size = new System.Drawing.Size(64, 16);
			this.lblName.Text = "Name";
			// 
			// lblCurrent
			// 
			this.lblCurrent.Location = new System.Drawing.Point(9, 176);
			this.lblCurrent.Size = new System.Drawing.Size(112, 24);
			// 
			// cmdSaveEntry
			// 
			this.cmdSaveEntry.Location = new System.Drawing.Point(129, 240);
			this.cmdSaveEntry.Size = new System.Drawing.Size(104, 24);
			this.cmdSaveEntry.Text = "Save Entry";
			this.cmdSaveEntry.Click += new System.EventHandler(this.cmdSaveEntry_Click);
			// 
			// txtLocal
			// 
			this.txtLocal.Location = new System.Drawing.Point(97, 56);
			this.txtLocal.Size = new System.Drawing.Size(136, 20);
			this.txtLocal.Text = "";
			// 
			// txtInternational
			// 
			this.txtInternational.Location = new System.Drawing.Point(97, 104);
			this.txtInternational.Size = new System.Drawing.Size(136, 20);
			this.txtInternational.Text = "";
			// 
			// lblLong
			// 
			this.lblLong.Location = new System.Drawing.Point(9, 80);
			this.lblLong.Size = new System.Drawing.Size(80, 16);
			this.lblLong.Text = "Long Distance";
			// 
			// txtArea
			// 
			this.txtArea.Location = new System.Drawing.Point(177, 128);
			this.txtArea.Size = new System.Drawing.Size(56, 20);
			this.txtArea.Text = "";
			// 
			// cmdBack
			// 
			this.cmdBack.Location = new System.Drawing.Point(9, 240);
			this.cmdBack.Size = new System.Drawing.Size(104, 24);
			this.cmdBack.Text = "Back";
			this.cmdBack.Click += new System.EventHandler(this.cmdBack_Click);
			// 
			// cboName
			// 
			this.cboName.Location = new System.Drawing.Point(97, 8);
			this.cboName.Size = new System.Drawing.Size(136, 21);
			this.cboName.SelectedIndexChanged += new System.EventHandler(this.cboName_SelectedIndexChanged);
			// 
			// cmdCurrent
			// 
			this.cmdCurrent.Location = new System.Drawing.Point(129, 176);
			this.cmdCurrent.Size = new System.Drawing.Size(104, 24);
			this.cmdCurrent.Text = "Set as Current";
			this.cmdCurrent.Click += new System.EventHandler(this.cmdCurrent_Click);
			// 
			// lblLocal
			// 
			this.lblLocal.Location = new System.Drawing.Point(9, 56);
			this.lblLocal.Size = new System.Drawing.Size(64, 16);
			this.lblLocal.Text = "Local Calls";
			// 
			// lblCountry
			// 
			this.lblCountry.Location = new System.Drawing.Point(9, 128);
			this.lblCountry.Size = new System.Drawing.Size(56, 16);
			this.lblCountry.Text = "Country";
			// 
			// lblLocs
			// 
			this.lblLocs.Location = new System.Drawing.Point(9, 8);
			this.lblLocs.Size = new System.Drawing.Size(64, 16);
			this.lblLocs.Text = "Locations";
			// 
			// cmdNewEntry
			// 
			this.cmdNewEntry.Location = new System.Drawing.Point(9, 208);
			this.cmdNewEntry.Size = new System.Drawing.Size(104, 24);
			this.cmdNewEntry.Text = "New Entry";
			this.cmdNewEntry.Click += new System.EventHandler(this.cmdNewEntry_Click);
			// 
			// cmdDelete
			// 
			this.cmdDelete.Location = new System.Drawing.Point(129, 208);
			this.cmdDelete.Size = new System.Drawing.Size(104, 24);
			this.cmdDelete.Text = "Delete Entry";
			this.cmdDelete.Click += new System.EventHandler(this.cmdDelete_Click);
			// 
			// lblInternational
			// 
			this.lblInternational.Location = new System.Drawing.Point(9, 104);
			this.lblInternational.Size = new System.Drawing.Size(80, 16);
			this.lblInternational.Text = "International";
			// 
			// lblArea
			// 
			this.lblArea.Location = new System.Drawing.Point(137, 128);
			this.lblArea.Size = new System.Drawing.Size(32, 16);
			this.lblArea.Text = "Area";
			// 
			// lblText
			// 
			this.lblText.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular);
			this.lblText.Location = new System.Drawing.Point(17, 152);
			this.lblText.Size = new System.Drawing.Size(208, 16);
			this.lblText.Text = "E,e = country; F,f = area; G,g = number";
			// 
			// txtCountry
			// 
			this.txtCountry.Location = new System.Drawing.Point(73, 128);
			this.txtCountry.Size = new System.Drawing.Size(56, 20);
			this.txtCountry.Text = "";
			// 
			// txtLong
			// 
			this.txtLong.Location = new System.Drawing.Point(97, 80);
			this.txtLong.Size = new System.Drawing.Size(136, 20);
			this.txtLong.Text = "";
			// 
			// frmSetLocation
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.txtName);
			this.Controls.Add(this.lblName);
			this.Controls.Add(this.lblCurrent);
			this.Controls.Add(this.cmdSaveEntry);
			this.Controls.Add(this.txtLocal);
			this.Controls.Add(this.txtInternational);
			this.Controls.Add(this.lblLong);
			this.Controls.Add(this.txtArea);
			this.Controls.Add(this.cmdBack);
			this.Controls.Add(this.cboName);
			this.Controls.Add(this.cmdCurrent);
			this.Controls.Add(this.lblLocal);
			this.Controls.Add(this.lblCountry);
			this.Controls.Add(this.lblLocs);
			this.Controls.Add(this.cmdNewEntry);
			this.Controls.Add(this.cmdDelete);
			this.Controls.Add(this.lblInternational);
			this.Controls.Add(this.lblArea);
			this.Controls.Add(this.lblText);
			this.Controls.Add(this.txtCountry);
			this.Controls.Add(this.txtLong);
			this.Menu = this.mainMenu1;
			this.Text = "Set Locations";

		}
		#endregion

		private void cmdBack_Click(object sender, System.EventArgs e)
		{
			clsMain.fRASMenu.Show();
			this.Hide();
		}

		private void cmdSaveEntry_Click(object sender, System.EventArgs e)
		{
			int iResult;
			int iNumber;

			iNumber = clsLocation.LOCGetNumber();

			if (cboName.SelectedIndex != -1)
			{
				if (MessageBox.Show("Existing Location, Do you wish to continue?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
					return;
				clsListItem oComboName = (clsListItem)cboName.SelectedItem;
				iNumber = oComboName.iValue;
			}
			else
			{
				clsLocation.LOCSetNumber(iNumber + 1);
			}

			iResult = clsLocation.LOCSetLocation(iNumber, txtName.Text, txtLocal.Text, txtLong.Text, txtInternational.Text, txtArea.Text, txtCountry.Text);

			if (iResult != 0)
			{
				MessageBox.Show(clsRAS.RASErrMsg(iResult));
			}
			else
			{
				clsLocation.RefreshLocations();
				clsLocation.SetLOCName(iNumber);
			}
		}

		private void cboName_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			// Show current location.
			if (cboName.SelectedIndex != -1)
			{
				clsListItem oComboName = (clsListItem)cboName.SelectedItem;
				if (clsLocation.LOCGetCurrent() == oComboName.iValue)
					lblCurrent.Text = "Current Location";
				else
				    lblCurrent.Text = "";
            
	            txtName.Text = cboName.Text;

				clsLocation.SetLOCValues(oComboName.iValue);
			}
		}
		
		public void loadSetLocation()
		{
			int iCurrent;

			iCurrent = clsLocation.LOCGetCurrent();
			lblCurrent.Text = "Current Location";
			clsLocation.SetLOCName(iCurrent);
		}

		private void cmdCurrent_Click(object sender, System.EventArgs e)
		{
			int iResult;
			int iNumber;

			clsListItem oComboName = (clsListItem)cboName.SelectedItem;
			iNumber = oComboName.iValue;
			iResult = clsLocation.LOCSetCurrent(iNumber);
			if (iResult != 0)
				MessageBox.Show(clsRAS.RASErrMsg(iResult));
			else
				lblCurrent.Text = "Current Location";
		}

		private void cmdDelete_Click(object sender, System.EventArgs e)
		{
			int iResult;
			int iCurrent;

			if (cboName.SelectedIndex < 0)
				return;

			clsListItem oComboName = (clsListItem)cboName.SelectedItem;
			if (oComboName.iValue < 2)
			{
				MessageBox.Show("System Location - Not able to Delete");
				return;
			}

			if (MessageBox.Show("Are you sure you want to delete " + cboName.Text + " ?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
	            return;

			if (clsLocation.LOCGetCurrent() == oComboName.iValue)
				clsLocation.LOCSetCurrent(0);
        
			iResult = clsLocation.LOCDeleteLocation(oComboName.iValue);
			if (iResult != 0)
			{
				MessageBox.Show(clsRAS.RASErrMsg(iResult));
			}
			else
			{
				clsLocation.RefreshLocations();
				iCurrent = clsLocation.LOCGetCurrent();
				lblCurrent.Text = "Current Location";
				clsLocation.SetLOCName(iCurrent);
			}
		}

		private void cmdNewEntry_Click(object sender, System.EventArgs e)
		{
			cboName.SelectedIndex = -1;
			txtName.Text = "";
			txtLocal.Text = "E";
			txtLong.Text = "0EF";
			txtInternational.Text = "00EFG";
			txtArea.Text = "";
			txtCountry.Text = "";
			lblCurrent.Text = "";

			txtName.Focus();
		}
	}
}
