using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace RASDemo
{
	/// <summary>
	/// Summary description for frmSetPB.
	/// </summary>
	public class frmSetPB : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button cmdNew;
		internal System.Windows.Forms.Label lblPhonebook;
		internal System.Windows.Forms.TextBox txtName;
		internal System.Windows.Forms.Label lblName;
		internal System.Windows.Forms.Button cmdRename;
		internal System.Windows.Forms.ComboBox cboDevice;
		internal System.Windows.Forms.Label lblAreaCode;
		internal System.Windows.Forms.TextBox txtCountryCode;
		internal System.Windows.Forms.Button cmdDelete;
		internal System.Windows.Forms.Label lblCountryCode;
		internal System.Windows.Forms.TextBox txtLocalPhoneNumber;
		internal System.Windows.Forms.TextBox txtAreaCode;
		internal System.Windows.Forms.ComboBox cboEntry;
		internal System.Windows.Forms.Button cmdAdvanced;
		internal System.Windows.Forms.Button cmdSaveEntry;
		internal System.Windows.Forms.ComboBox cboDestination;
		internal System.Windows.Forms.Label lblLocalPhoneNumber;
		internal System.Windows.Forms.Button cmdBack;
		internal System.Windows.Forms.Label lblDestination;
		private System.Windows.Forms.MainMenu mainMenu1;
		private Microsoft.WindowsCE.Forms.InputPanel inputPanel1;
		internal System.Windows.Forms.Label lblDeviceName;
	
		public frmSetPB()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdNew = new System.Windows.Forms.Button();
			this.lblPhonebook = new System.Windows.Forms.Label();
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblName = new System.Windows.Forms.Label();
			this.cmdRename = new System.Windows.Forms.Button();
			this.cboDevice = new System.Windows.Forms.ComboBox();
			this.lblAreaCode = new System.Windows.Forms.Label();
			this.txtCountryCode = new System.Windows.Forms.TextBox();
			this.cmdDelete = new System.Windows.Forms.Button();
			this.lblCountryCode = new System.Windows.Forms.Label();
			this.txtLocalPhoneNumber = new System.Windows.Forms.TextBox();
			this.txtAreaCode = new System.Windows.Forms.TextBox();
			this.cboEntry = new System.Windows.Forms.ComboBox();
			this.cmdAdvanced = new System.Windows.Forms.Button();
			this.cmdSaveEntry = new System.Windows.Forms.Button();
			this.cboDestination = new System.Windows.Forms.ComboBox();
			this.lblLocalPhoneNumber = new System.Windows.Forms.Label();
			this.cmdBack = new System.Windows.Forms.Button();
			this.lblDestination = new System.Windows.Forms.Label();
			this.lblDeviceName = new System.Windows.Forms.Label();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.inputPanel1 = new Microsoft.WindowsCE.Forms.InputPanel();
			// 
			// cmdNew
			// 
			this.cmdNew.Location = new System.Drawing.Point(8, 176);
			this.cmdNew.Size = new System.Drawing.Size(104, 24);
			this.cmdNew.Text = "New Entry";
			this.cmdNew.Click += new System.EventHandler(this.cmdNew_Click);
			// 
			// lblPhonebook
			// 
			this.lblPhonebook.Location = new System.Drawing.Point(8, 8);
			this.lblPhonebook.Size = new System.Drawing.Size(80, 16);
			this.lblPhonebook.Text = "Phonebook";
			// 
			// txtName
			// 
			this.txtName.Location = new System.Drawing.Point(97, 32);
			this.txtName.Size = new System.Drawing.Size(136, 20);
			this.txtName.Text = "";
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(9, 32);
			this.lblName.Size = new System.Drawing.Size(80, 16);
			this.lblName.Text = "Name";
			// 
			// cmdRename
			// 
			this.cmdRename.Location = new System.Drawing.Point(129, 208);
			this.cmdRename.Size = new System.Drawing.Size(104, 24);
			this.cmdRename.Text = "Rename Entry";
			this.cmdRename.Click += new System.EventHandler(this.cmdRename_Click);
			// 
			// cboDevice
			// 
			this.cboDevice.Location = new System.Drawing.Point(96, 128);
			this.cboDevice.Size = new System.Drawing.Size(136, 21);
			// 
			// lblAreaCode
			// 
			this.lblAreaCode.Location = new System.Drawing.Point(9, 80);
			this.lblAreaCode.Size = new System.Drawing.Size(80, 16);
			this.lblAreaCode.Text = "Area Code";
			// 
			// txtCountryCode
			// 
			this.txtCountryCode.Location = new System.Drawing.Point(97, 56);
			this.txtCountryCode.Size = new System.Drawing.Size(136, 20);
			this.txtCountryCode.Text = "";
			// 
			// cmdDelete
			// 
			this.cmdDelete.Location = new System.Drawing.Point(9, 208);
			this.cmdDelete.Size = new System.Drawing.Size(104, 24);
			this.cmdDelete.Text = "Delete Entry";
			this.cmdDelete.Click += new System.EventHandler(this.cmdDelete_Click);
			// 
			// lblCountryCode
			// 
			this.lblCountryCode.Location = new System.Drawing.Point(9, 56);
			this.lblCountryCode.Size = new System.Drawing.Size(80, 16);
			this.lblCountryCode.Text = "Country Code";
			// 
			// txtLocalPhoneNumber
			// 
			this.txtLocalPhoneNumber.Location = new System.Drawing.Point(97, 104);
			this.txtLocalPhoneNumber.Size = new System.Drawing.Size(136, 20);
			this.txtLocalPhoneNumber.Text = "";
			// 
			// txtAreaCode
			// 
			this.txtAreaCode.Location = new System.Drawing.Point(97, 80);
			this.txtAreaCode.Size = new System.Drawing.Size(136, 20);
			this.txtAreaCode.Text = "";
			// 
			// cboEntry
			// 
			this.cboEntry.Location = new System.Drawing.Point(96, 8);
			this.cboEntry.Size = new System.Drawing.Size(136, 21);
			this.cboEntry.SelectedIndexChanged += new System.EventHandler(this.cboEntry_SelectedIndexChanged);
			// 
			// cmdAdvanced
			// 
			this.cmdAdvanced.Location = new System.Drawing.Point(128, 176);
			this.cmdAdvanced.Size = new System.Drawing.Size(104, 24);
			this.cmdAdvanced.Text = "Advanced";
			this.cmdAdvanced.Click += new System.EventHandler(this.cmdAdvanced_Click);
			// 
			// cmdSaveEntry
			// 
			this.cmdSaveEntry.Location = new System.Drawing.Point(128, 240);
			this.cmdSaveEntry.Size = new System.Drawing.Size(104, 24);
			this.cmdSaveEntry.Text = "Save Entry";
			this.cmdSaveEntry.Click += new System.EventHandler(this.cmdSaveEntry_Click);
			// 
			// cboDestination
			// 
			this.cboDestination.Location = new System.Drawing.Point(96, 152);
			this.cboDestination.Size = new System.Drawing.Size(136, 21);
			// 
			// lblLocalPhoneNumber
			// 
			this.lblLocalPhoneNumber.Location = new System.Drawing.Point(9, 104);
			this.lblLocalPhoneNumber.Size = new System.Drawing.Size(80, 16);
			this.lblLocalPhoneNumber.Text = "Number";
			// 
			// cmdBack
			// 
			this.cmdBack.Location = new System.Drawing.Point(9, 240);
			this.cmdBack.Size = new System.Drawing.Size(104, 24);
			this.cmdBack.Text = "Back";
			this.cmdBack.Click += new System.EventHandler(this.cmdBack_Click);
			// 
			// lblDestination
			// 
			this.lblDestination.Location = new System.Drawing.Point(9, 152);
			this.lblDestination.Size = new System.Drawing.Size(80, 16);
			this.lblDestination.Text = "Destination";
			// 
			// lblDeviceName
			// 
			this.lblDeviceName.Location = new System.Drawing.Point(9, 128);
			this.lblDeviceName.Size = new System.Drawing.Size(48, 16);
			this.lblDeviceName.Text = "Device";
			// 
			// frmSetPB
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.cmdNew);
			this.Controls.Add(this.lblPhonebook);
			this.Controls.Add(this.txtName);
			this.Controls.Add(this.lblName);
			this.Controls.Add(this.cmdRename);
			this.Controls.Add(this.cboDevice);
			this.Controls.Add(this.lblAreaCode);
			this.Controls.Add(this.txtCountryCode);
			this.Controls.Add(this.cmdDelete);
			this.Controls.Add(this.lblCountryCode);
			this.Controls.Add(this.txtLocalPhoneNumber);
			this.Controls.Add(this.txtAreaCode);
			this.Controls.Add(this.cboEntry);
			this.Controls.Add(this.cmdAdvanced);
			this.Controls.Add(this.cmdSaveEntry);
			this.Controls.Add(this.cboDestination);
			this.Controls.Add(this.lblLocalPhoneNumber);
			this.Controls.Add(this.cmdBack);
			this.Controls.Add(this.lblDestination);
			this.Controls.Add(this.lblDeviceName);
			this.Menu = this.mainMenu1;
			this.Text = "Set Phone Book";

		}
		#endregion

		private void cmdAdvanced_Click(object sender, System.EventArgs e)
		{
			// Show screens for optional advanced settings (No available on all platforms).
			clsMain.bGPRS = false;
			clsMain.fSetPBAdv1.Show();
			this.Hide();
		}

		private void cmdDelete_Click(object sender, System.EventArgs e)
		{
			int iResult;

			if (cboEntry.Text.Substring(0,1) == "`")
			{
				MessageBox.Show("System Connection - Not able to Delete");
				return;
			}

			if (MessageBox.Show("Are you sure you want to delete " + cboEntry.Text + " ?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
				return;

			iResult = clsPB.PBDelete(cboEntry.Text);
			if (iResult != 0)
				MessageBox.Show(clsRAS.RASErrMsg(iResult));
			else
				clsPB.RefreshNames();
		}

		private void cmdRename_Click(object sender, System.EventArgs e)
		{
			int iResult;

			if (cboEntry.Text.Substring(0,1) == "`")
			{
				MessageBox.Show("System Connection - Not able to Rename");
				return;
			}

			iResult = clsPB.PBValidate(txtName.Text);

			if (iResult != 0)
			{
				if (MessageBox.Show(clsRAS.RASErrMsg(iResult) + ", Do you wish to continue?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
					return;
			}

			if (cboEntry.Text != txtName.Text)
			{
				if (MessageBox.Show("Renaming Phonebook Entry " + cboEntry.Text + " to " + txtName.Text + ", Do you wish to continue?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)
				{
					iResult = clsPB.PBRename(cboEntry.Text, txtName.Text);
					if (iResult != 0)
						MessageBox.Show(clsRAS.RASErrMsg(iResult));
					else
						clsPB.RefreshNames();
				}
			}
		}

		private void cmdBack_Click(object sender, System.EventArgs e)
		{
			clsMain.fRASMenu.Show();
			this.Hide();
		}

		private void cmdSaveEntry_Click(object sender, System.EventArgs e)
		{
			int iResult;

			if (txtName.Text.Substring(0,1) == "`")
			{
				MessageBox.Show("System Connection - Not able to Change");
				return;
			}

			// Check that this name has not be used previously, prompt for overwrite if need be.
			iResult = clsPB.PBValidate(txtName.Text);

			if (iResult != 0)
			{
				if (MessageBox.Show(clsRAS.RASErrMsg(iResult) + ", Do you wish to continue?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
					return;
			}

			iResult = clsPB.PBSet(txtName.Text, txtCountryCode.Text, txtAreaCode.Text,
				txtLocalPhoneNumber.Text, cboDevice.Text, cboDestination.Text,
				clsMain.fSetPBAdv1.cboBaud.Text, clsMain.fSetPBAdv1.cboBits.Text, clsMain.fSetPBAdv1.cboParity.Text,
				clsMain.fSetPBAdv1.cboStop.Text, clsMain.fSetPBAdv4.txtTimeout.Text,
				clsMain.fSetPBAdv1.optIntCall.Checked, clsMain.fSetPBAdv1.optLocalCall.Checked,
				clsMain.fSetPBAdv2.optSpecific.Checked, clsMain.fSetPBAdv2.txtIPAddress1.Text,
				clsMain.fSetPBAdv2.txtIPAddress2.Text, clsMain.fSetPBAdv2.txtIPAddress3.Text,
				clsMain.fSetPBAdv2.txtIPAddress4.Text, clsMain.fSetPBAdv3.optSpecific.Checked,
				clsMain.fSetPBAdv3.txtDNSAddress1.Text, clsMain.fSetPBAdv3.txtDNSAddress2.Text,
				clsMain.fSetPBAdv3.txtDNSAddress3.Text, clsMain.fSetPBAdv3.txtDNSAddress4.Text,
				clsMain.fSetPBAdv3.txtAltDNSAddress1.Text, clsMain.fSetPBAdv3.txtAltDNSAddress2.Text,
				clsMain.fSetPBAdv3.txtAltDNSAddress3.Text, clsMain.fSetPBAdv3.txtAltDNSAddress4.Text,
				clsMain.fSetPBAdv3.txtWINSAddress1.Text, clsMain.fSetPBAdv3.txtWINSAddress2.Text,
				clsMain.fSetPBAdv3.txtWINSAddress3.Text, clsMain.fSetPBAdv3.txtWINSAddress4.Text,
				clsMain.fSetPBAdv3.txtAltWINSAddress1.Text, clsMain.fSetPBAdv3.txtAltWINSAddress2.Text,
				clsMain.fSetPBAdv3.txtAltWINSAddress3.Text, clsMain.fSetPBAdv3.txtAltWINSAddress4.Text,
				clsMain.fSetPBAdv2.chkIPHeader.Checked, clsMain.fSetPBAdv2.chkSoftware.Checked,
				clsMain.fSetPBAdv2.chkSlip.Checked, false,
				clsMain.fSetPBAdv1.cboFlowControl.Text, clsMain.fSetPBAdv4.txtCredit.Text,
				clsMain.fSetPBAdv4.txtExtraDial.Text, clsMain.fSetPBAdv4.chkBefore.Checked,
				clsMain.fSetPBAdv4.chkAfter.Checked, clsMain.fSetPBAdv4.chkManually.Checked,
				clsMain.fSetPBAdv4.chkWait.Checked);

			if (iResult != 0)
				MessageBox.Show(clsRAS.RASErrMsg(iResult));
			else
				clsPB.RefreshNames();
		}

		private void cboEntry_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cboEntry.SelectedIndex != -1)
				clsPB.SetPBValues(cboEntry.Text);
		}

		private void cmdNew_Click(object sender, System.EventArgs e)
		{
			clsMain.fSetPB.cboEntry.SelectedIndex = -1;
			clsMain.fSetPB.txtName.Text = "";
			clsMain.fSetPB.txtCountryCode.Text = "";
			clsMain.fSetPB.txtAreaCode.Text = "";
			clsMain.fSetPB.txtLocalPhoneNumber.Text = "";
			clsMain.fSetPB.cboDevice.SelectedIndex = -1;
			clsMain.fSetPB.cboDestination.SelectedIndex = -1;
			clsMain.fSetPBAdv1.cboBaud.Text = "19200";
			clsMain.fSetPBAdv1.cboBits.Text = "8";
			clsMain.fSetPBAdv1.cboParity.Text = "None";
			clsMain.fSetPBAdv1.cboStop.Text = "1";
			clsMain.fSetPBAdv1.cboFlowControl.Text = "Hardware";
			clsMain.fSetPBAdv1.optIntCall.Checked = false;
			clsMain.fSetPBAdv1.optLocalCall.Checked = false;

			clsMain.fSetPBAdv2.optServerAssigned.Checked = true;
			clsPB.IPServerAssigned();
			clsMain.fSetPBAdv2.txtIPAddress1.Text = "0";
			clsMain.fSetPBAdv2.txtIPAddress2.Text = "0";
			clsMain.fSetPBAdv2.txtIPAddress3.Text = "0";
			clsMain.fSetPBAdv2.txtIPAddress4.Text = "0";
			clsMain.fSetPBAdv2.chkIPHeader.Checked = true;
			clsMain.fSetPBAdv2.chkSoftware.Checked = true;
			clsMain.fSetPBAdv2.chkSlip.Checked = false;

			clsMain.fSetPBAdv3.optServerAssigned.Checked = true;
			clsPB.NameServerAssigned();
			clsMain.fSetPBAdv3.txtDNSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtDNSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtDNSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtDNSAddress4.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress4.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress4.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress4.Text = "0";

			clsMain.fSetPBAdv4.txtTimeout.Text = "120";
			clsMain.fSetPBAdv4.txtCredit.Text = "0";
			clsMain.fSetPBAdv4.txtExtraDial.Text = "";
			clsMain.fSetPBAdv4.chkBefore.Checked = false;
			clsMain.fSetPBAdv4.chkAfter.Checked = false;
			clsMain.fSetPBAdv4.chkManually.Checked = false;
			clsMain.fSetPBAdv4.chkWait.Checked = true;

			clsMain.fSetPB.txtName.Focus();
		}
	}
}
