using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace RASDemo
{
	/// <summary>
	/// Summary description for frmSetPBGprs.
	/// </summary>
	public class frmSetPBGprs : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button cmdAdvanced;
		internal System.Windows.Forms.Label lblHelp;
		internal System.Windows.Forms.Button cmdNew;
		internal System.Windows.Forms.Label lblDestination;
		internal System.Windows.Forms.TextBox txtName;
		internal System.Windows.Forms.ComboBox cboDevice;
		internal System.Windows.Forms.Label lblDomain;
		internal System.Windows.Forms.Label lblDeviceName;
		internal System.Windows.Forms.TextBox txtDomain;
		internal System.Windows.Forms.Label lblName;
		internal System.Windows.Forms.Button cmdSaveEntry;
		internal System.Windows.Forms.ComboBox cboDestination;
		private System.Windows.Forms.MainMenu mainMenu1;
		private Microsoft.WindowsCE.Forms.InputPanel inputPanel1;
		internal System.Windows.Forms.Button cmdBack;
	
		public frmSetPBGprs()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdAdvanced = new System.Windows.Forms.Button();
			this.lblHelp = new System.Windows.Forms.Label();
			this.cmdNew = new System.Windows.Forms.Button();
			this.lblDestination = new System.Windows.Forms.Label();
			this.txtName = new System.Windows.Forms.TextBox();
			this.cboDevice = new System.Windows.Forms.ComboBox();
			this.lblDomain = new System.Windows.Forms.Label();
			this.lblDeviceName = new System.Windows.Forms.Label();
			this.txtDomain = new System.Windows.Forms.TextBox();
			this.lblName = new System.Windows.Forms.Label();
			this.cmdSaveEntry = new System.Windows.Forms.Button();
			this.cboDestination = new System.Windows.Forms.ComboBox();
			this.cmdBack = new System.Windows.Forms.Button();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.inputPanel1 = new Microsoft.WindowsCE.Forms.InputPanel();
			// 
			// cmdAdvanced
			// 
			this.cmdAdvanced.Location = new System.Drawing.Point(128, 208);
			this.cmdAdvanced.Size = new System.Drawing.Size(104, 24);
			this.cmdAdvanced.Text = "Advanced";
			this.cmdAdvanced.Click += new System.EventHandler(this.cmdAdvanced_Click);
			// 
			// lblHelp
			// 
			this.lblHelp.Location = new System.Drawing.Point(8, 144);
			this.lblHelp.Size = new System.Drawing.Size(224, 48);
			this.lblHelp.Text = "Notes: Create GPRS connections only. Enter a name, select a device type and desti" +
				"nation then click \"Save Entry\"";
			this.lblHelp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// cmdNew
			// 
			this.cmdNew.Location = new System.Drawing.Point(8, 208);
			this.cmdNew.Size = new System.Drawing.Size(104, 24);
			this.cmdNew.Text = "New Entry";
			this.cmdNew.Click += new System.EventHandler(this.cmdNew_Click);
			// 
			// lblDestination
			// 
			this.lblDestination.Location = new System.Drawing.Point(8, 104);
			this.lblDestination.Size = new System.Drawing.Size(80, 16);
			this.lblDestination.Text = "Destination";
			// 
			// txtName
			// 
			this.txtName.Location = new System.Drawing.Point(96, 8);
			this.txtName.Size = new System.Drawing.Size(136, 20);
			this.txtName.Text = "";
			// 
			// cboDevice
			// 
			this.cboDevice.Location = new System.Drawing.Point(96, 72);
			this.cboDevice.Size = new System.Drawing.Size(136, 21);
			// 
			// lblDomain
			// 
			this.lblDomain.Location = new System.Drawing.Point(8, 40);
			this.lblDomain.Size = new System.Drawing.Size(80, 16);
			this.lblDomain.Text = "Domain";
			// 
			// lblDeviceName
			// 
			this.lblDeviceName.Location = new System.Drawing.Point(8, 72);
			this.lblDeviceName.Size = new System.Drawing.Size(80, 16);
			this.lblDeviceName.Text = "Device";
			// 
			// txtDomain
			// 
			this.txtDomain.Location = new System.Drawing.Point(96, 40);
			this.txtDomain.Size = new System.Drawing.Size(136, 20);
			this.txtDomain.Text = "";
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 8);
			this.lblName.Size = new System.Drawing.Size(80, 16);
			this.lblName.Text = "Name";
			// 
			// cmdSaveEntry
			// 
			this.cmdSaveEntry.Location = new System.Drawing.Point(128, 240);
			this.cmdSaveEntry.Size = new System.Drawing.Size(104, 24);
			this.cmdSaveEntry.Text = "Save Entry";
			this.cmdSaveEntry.Click += new System.EventHandler(this.cmdSaveEntry_Click);
			// 
			// cboDestination
			// 
			this.cboDestination.Location = new System.Drawing.Point(96, 104);
			this.cboDestination.Size = new System.Drawing.Size(136, 21);
			// 
			// cmdBack
			// 
			this.cmdBack.Location = new System.Drawing.Point(8, 240);
			this.cmdBack.Size = new System.Drawing.Size(104, 24);
			this.cmdBack.Text = "Back";
			this.cmdBack.Click += new System.EventHandler(this.cmdBack_Click);
			// 
			// frmSetPBGprs
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.cmdAdvanced);
			this.Controls.Add(this.lblHelp);
			this.Controls.Add(this.cmdNew);
			this.Controls.Add(this.lblDestination);
			this.Controls.Add(this.txtName);
			this.Controls.Add(this.cboDevice);
			this.Controls.Add(this.lblDomain);
			this.Controls.Add(this.lblDeviceName);
			this.Controls.Add(this.txtDomain);
			this.Controls.Add(this.lblName);
			this.Controls.Add(this.cmdSaveEntry);
			this.Controls.Add(this.cboDestination);
			this.Controls.Add(this.cmdBack);
			this.Menu = this.mainMenu1;
			this.Text = "Set GPRS";

		}
		#endregion

		private void cmdBack_Click(object sender, System.EventArgs e)
		{
			clsMain.fRASMenu.Show();
			this.Hide();
		}

		private void cmdSaveEntry_Click(object sender, System.EventArgs e)
		{
			int iResult;

			// Check that this name has not be used previously, prompt for overwrite if need be.
			iResult = clsPB.PBValidate(txtName.Text);

			if (iResult != 0)
			{
				if (MessageBox.Show(clsRAS.RASErrMsg(iResult) + ", Do you wish to continue?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
					return;
			}

			iResult = clsPB.PBSet(txtName.Text, "", "",
				"~GPRS!" + txtDomain.Text, cboDevice.Text, cboDestination.Text,
				"", "", "",
				"", "",
				false, false,
				clsMain.fSetPBAdv2.optSpecific.Checked, clsMain.fSetPBAdv2.txtIPAddress1.Text,
				clsMain.fSetPBAdv2.txtIPAddress2.Text, clsMain.fSetPBAdv2.txtIPAddress3.Text,
				clsMain.fSetPBAdv2.txtIPAddress4.Text, clsMain.fSetPBAdv3.optSpecific.Checked,
				clsMain.fSetPBAdv3.txtDNSAddress1.Text, clsMain.fSetPBAdv3.txtDNSAddress2.Text,
				clsMain.fSetPBAdv3.txtDNSAddress3.Text, clsMain.fSetPBAdv3.txtDNSAddress4.Text,
				clsMain.fSetPBAdv3.txtAltDNSAddress1.Text, clsMain.fSetPBAdv3.txtAltDNSAddress2.Text,
				clsMain.fSetPBAdv3.txtAltDNSAddress3.Text, clsMain.fSetPBAdv3.txtAltDNSAddress4.Text,
				clsMain.fSetPBAdv3.txtWINSAddress1.Text, clsMain.fSetPBAdv3.txtWINSAddress2.Text,
				clsMain.fSetPBAdv3.txtWINSAddress3.Text, clsMain.fSetPBAdv3.txtWINSAddress4.Text,
				clsMain.fSetPBAdv3.txtAltWINSAddress1.Text, clsMain.fSetPBAdv3.txtAltWINSAddress2.Text,
				clsMain.fSetPBAdv3.txtAltWINSAddress3.Text, clsMain.fSetPBAdv3.txtAltWINSAddress4.Text,
				clsMain.fSetPBAdv2.chkIPHeader.Checked, clsMain.fSetPBAdv2.chkSoftware.Checked,
				false, true,
				"Hardware", "",
				txtDomain.Text, false,
				false, false,
				false);

			if (iResult != 0)
				MessageBox.Show(clsRAS.RASErrMsg(iResult));
			else
				clsPB.RefreshNames();
		}

		private void cmdNew_Click(object sender, System.EventArgs e)
		{
			loadSetPBGprs();
		}

		private void cmdAdvanced_Click(object sender, System.EventArgs e)
		{
			// Show screens for optional advanced settings (No available on all platforms).
			clsMain.bGPRS = true;
			clsMain.fSetPBAdv2.Show();
			this.Hide();
		}

		public void loadSetPBGprs()
		{
			clsMain.fSetPBGprs.txtName.Text = ""; //gprs
			clsMain.fSetPBGprs.txtDomain.Text = ""; //gprs.domain.co.uk
			clsMain.fSetPBGprs.cboDevice.SelectedIndex = -1;
			clsMain.fSetPBGprs.cboDestination.SelectedIndex = -1;

			clsMain.fSetPBAdv2.optServerAssigned.Checked = true;
			clsPB.IPServerAssigned();
			clsMain.fSetPBAdv2.txtIPAddress1.Text = "0";
			clsMain.fSetPBAdv2.txtIPAddress2.Text = "0";
			clsMain.fSetPBAdv2.txtIPAddress3.Text = "0";
			clsMain.fSetPBAdv2.txtIPAddress4.Text = "0";
			clsMain.fSetPBAdv2.chkIPHeader.Checked = true;
			clsMain.fSetPBAdv2.chkSoftware.Checked = true;
			clsMain.fSetPBAdv2.chkSlip.Checked = false;

			clsMain.fSetPBAdv3.optServerAssigned.Checked = true;
			clsPB.NameServerAssigned();
			clsMain.fSetPBAdv3.txtDNSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtDNSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtDNSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtDNSAddress4.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtAltDNSAddress4.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtWINSAddress4.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress1.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress2.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress3.Text = "0";
			clsMain.fSetPBAdv3.txtAltWINSAddress4.Text = "0";

			clsMain.fSetPBGprs.txtName.Focus();
		}
	}
}
