Friend Class frmRASDialASync
    Inherits System.Windows.Forms.Form

    Friend hDC As Integer = FindWindow(Nothing, "frmRASDialASync")

    Dim iNot As Integer

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        MyBase.Dispose(disposing)
    End Sub

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents tmrStatus As System.Windows.Forms.Timer
    Friend WithEvents cmdHangUp As System.Windows.Forms.Button
    Friend WithEvents cmdDial As System.Windows.Forms.Button
    Friend WithEvents cmdBack As System.Windows.Forms.Button
    Friend WithEvents lblModem As System.Windows.Forms.Label
    Friend WithEvents lblHelp As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.tmrStatus = New System.Windows.Forms.Timer
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.cmdHangUp = New System.Windows.Forms.Button
        Me.cmdDial = New System.Windows.Forms.Button
        Me.cmdBack = New System.Windows.Forms.Button
        Me.lblModem = New System.Windows.Forms.Label
        Me.lblHelp = New System.Windows.Forms.Label
        '
        'tmrStatus
        '
        Me.tmrStatus.Interval = 200
        '
        'cmdHangUp
        '
        Me.cmdHangUp.Location = New System.Drawing.Point(32, 120)
        Me.cmdHangUp.Size = New System.Drawing.Size(176, 32)
        Me.cmdHangUp.Text = "Hang Up"
        '
        'cmdDial
        '
        Me.cmdDial.Location = New System.Drawing.Point(32, 72)
        Me.cmdDial.Size = New System.Drawing.Size(176, 32)
        Me.cmdDial.Text = "Dial Up"
        '
        'cmdBack
        '
        Me.cmdBack.Location = New System.Drawing.Point(144, 240)
        Me.cmdBack.Size = New System.Drawing.Size(88, 24)
        Me.cmdBack.Text = "Back"
        '
        'lblModem
        '
        Me.lblModem.Location = New System.Drawing.Point(8, 8)
        Me.lblModem.Size = New System.Drawing.Size(224, 56)
        Me.lblModem.Text = "Modem: Ready"
        '
        'lblHelp
        '
        Me.lblHelp.Location = New System.Drawing.Point(8, 168)
        Me.lblHelp.Size = New System.Drawing.Size(224, 56)
        Me.lblHelp.Text = "Notes: Async dial-up uses a timer so that the on-going status of the connection c" & _
        "an be viewed whilst connection  is in progress."
        Me.lblHelp.TextAlign = System.Drawing.ContentAlignment.TopCenter
        '
        'frmRASDialASync
        '
        Me.BackColor = System.Drawing.Color.Aqua
        Me.ControlBox = False
        Me.Controls.Add(Me.lblHelp)
        Me.Controls.Add(Me.cmdHangUp)
        Me.Controls.Add(Me.cmdDial)
        Me.Controls.Add(Me.cmdBack)
        Me.Controls.Add(Me.lblModem)
        Me.Menu = Me.MainMenu1
        Me.Text = "RAS Async"

    End Sub

#End Region

    Private Sub cmdDial_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDial.Click
        Dim iStatus As Integer
        Dim iResult As Integer
        Dim sEntry As String
        Dim sStoredUsername As String
        Dim sStoredPassword As String

        RASStatus()
        RASHangUp()
        iStatus = RASStatus()
        If iStatus = 0 Then
            sStoredUsername = ""
            sStoredPassword = ""
            ' Get the stored Username and Password for this connection
            sEntry = RASGetParams(sConnectionEntry)
            Dim sEntries() As String = Split(sEntry, "|", -1)
            If UBound(sEntries) > 0 Then
                sStoredUsername = sEntries(0)
                sStoredPassword = sEntries(1)
            End If

            If sStoredUsername = "" And sUsername = "" And sUserPass = True Then
                sUsername = InputBox("Enter Connection User Name")
                If sUsername = "" Then
                    If MsgBox("Continue without Username?", vbYesNo) = vbNo Then
                        Exit Sub
                    End If
                End If
            End If

            If sStoredPassword = "" And sPassword = "" And sUserPass = True Then
                sPassword = InputBox("Enter Connection Password")
                If sPassword = "" Then
                    If MsgBox("Continue without Password?", vbYesNo) = vbNo Then
                        Exit Sub
                    End If
                End If
            End If

            lblModem.Text = "Modem: Dialing Please Wait"
            ' Pass the handle for the current form so that error messages from the DLL are displayed on this form.
            iResult = RASDial(Me.hDC)

            If iResult = 0 Then
                tmrStatus.Enabled = True
                cmdDial.Enabled = False
                cmdHangUp.Enabled = True
                iNot = 0
            Else
                lblModem.Text = "Modem: Error-" & RASErrMsg(iResult)
                HangUp()
            End If
        End If
    End Sub

    Private Sub cmdHangUp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdHangUp.Click
        HangUp()
    End Sub

    Private Sub HangUp()
        Dim iStatus As Integer
        Dim iResult As Integer

        tmrStatus.Enabled = False
        iStatus = RASStatus()
        If iStatus <> 0 Then
            lblModem.Text = "Modem: Disconnecting Modem"
            lblModem.Update()
            iResult = RASHangUp()
            If iResult = 0 Then
                lblModem.Text = "Modem: Ready"
                lblModem.Update()
                cmdDial.Enabled = True
                cmdHangUp.Enabled = False
            Else
                lblModem.Text = "Modem: Error-" & RASErrMsg(iResult)
                lblModem.Update()
            End If
        Else
            lblModem.Text = "Modem: Ready"
            lblModem.Update()
            cmdDial.Enabled = True
            cmdHangUp.Enabled = False
        End If
    End Sub

    Private Sub cmdBack_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdBack.Click
        fRASDial.Show()
        Me.Hide()
    End Sub

    Private Sub tmrStatus_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrStatus.Tick
        Dim iResult As Integer
        Dim iStatus As Integer
        Dim sStatus As String
        Dim bLoop As Boolean

        tmrStatus.Enabled = False
        bLoop = True

        iStatus = 0
        ' Check and report connection status every 200ms
        iStatus = RASStatus()
        Select Case iStatus
            Case 25 ' Lost Connection
                iResult = RASHangUp()
                cmdDial.Enabled = True
                cmdHangUp.Enabled = False
                bLoop = False
            Case 1 ' Connected
                bLoop = False
        End Select

        sStatus = RASStatusMsg(iStatus)
        lblModem.Text = "Modem: " & sStatus & " " & RASCurrentConn()
        lblModem.Update()

        If iStatus = 25 Then
            HangUp()
        End If

        If iStatus = 1 Then
            'StartFTP()
        End If

        If iStatus = 0 Then
            HangUp()
        End If

        If iStatus = 0 Then
            iNot = iNot + 1
        End If

        If iNot > 20 Then
            bLoop = False
            HangUp()
        End If

        If bLoop = True Then
            tmrStatus.Enabled = True
        End If
    End Sub

    Friend Sub loadRASDial()
        Dim sCurrentConn As String

        lblModem.Text = "Modem: Ready"
        lblModem.Update()
        ' Show the current connection if present.
        sCurrentConn = RASCurrentConn()
        If sCurrentConn <> "" Then
            sConnectionEntry = sCurrentConn
            fSetDial.cboEntry.Text = sConnectionEntry
            tmrStatus.Enabled = True
            cmdDial.Enabled = False
            cmdHangUp.Enabled = True
        Else
            cmdDial.Enabled = True
            cmdHangUp.Enabled = False
        End If
    End Sub

    Private Sub frmRASDialASync_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub
End Class