using System;
using System.Runtime.InteropServices;

namespace RASDemo
{
	/// <summary>
	/// Summary description for clsPB.
	/// </summary>
	public class clsPB
	{
		public clsPB()
		{
		}

		[DllImport("SapphireRAS.dll")]
		public static extern int sPBNames(ref int iEntries, string sRASNames);

		[DllImport("SapphireRAS.dll")]
		public static extern int sPBDevices(ref int iEntries, string sRASDevices);

		[DllImport("SapphireRAS.dll")]
		public static extern int sPBGet(string sEntryName, string sPBData, int iLicence);
																											   
		[DllImport("SapphireRAS.dll")]
		public static extern int sPBSet(string sEntryName, string sNumbers,
			string sExtraInfo, string sSettings, int iPBBefore, int iPBAfter,
			int iPBManually, int iPBWait, int iUseCountryAndAreaCodes,
			int iDialAsLocalCall, int iSpecificIpAddr, string sIPAddress,
			int iSpecificNameServers, string sIPAddresses, int iIpHeaderCompression,
			int iSwCompression, int iSlip, int iGPRS, int iLicence);

		[DllImport("SapphireRAS.dll")]
		public static extern int sPBValidate(string sEntryName);

		[DllImport("SapphireRAS.dll")]
		public static extern int sPBDelete(string sEntryName, int iLicence);
		
		[DllImport("SapphireRAS.dll")]
		public static extern int sPBRename(string sOldEntryName, string sNewEntryName, int iLicence);
		
		[DllImport("SapphireRAS.dll")]
		public static extern int sPBGetWorkInternet();
		
		[DllImport("SapphireRAS.dll")]
		public static extern int sPBSetWorkInternet(int iNumber);
		
		[DllImport("SapphireRAS.dll")]
		public static extern int sPBSetDefault(string sEntryName, int iLicence);
		
		[DllImport("SapphireRAS.dll")]
		public static extern int sPBDestinations(string sDestNames);
		
		public static string PBNames(ref int iEntries)
		{
			string sRASNames = new String(' ',2048);
			sPBNames(ref iEntries, sRASNames);
			sRASNames = sRASNames.TrimEnd(' ');
			sRASNames = sRASNames.TrimEnd(Convert.ToChar(0x0000));
			return sRASNames;
		}

		public static string PBDevices(ref int iEntries)
		{
			string sRASDevices = new String(' ',2048);
			sPBDevices(ref iEntries, sRASDevices);
			sRASDevices = sRASDevices.TrimEnd(' ');
			sRASDevices = sRASDevices.TrimEnd(Convert.ToChar(0x0000));
			return sRASDevices;
		}
		
		public static string PBGet(string sPBEntry)
		{
			string sPBData = new String(' ',2048);
			sPBGet(sPBEntry, sPBData, clsMain.SapphireRASLicence);
			sPBData = sPBData.TrimEnd(' ');
			sPBData = sPBData.TrimEnd(Convert.ToChar(0x0000));
			return sPBData;
		}
		
		public static int PBSet(string sPBEntryName, string sPBCountryCode,
			string sPBAreaCode, string sPBLocalPhoneNumber, string sPBDeviceName,
			string sPBDestination, string sPBBaudRate, string sPBByteSize,
			string sPBParity, string sPBStopBits, string sPBSecBeforeHangup,
			bool bPBUseCountryAndAreaCodes, bool bPBDialAsLocalCall, bool bPBSpecificIpAddr,
			string sPBIPAddress1, string sPBIPAddress2, string sPBIPAddress3,
			string sPBIPAddress4, bool bPBSpecificNameServers, string sPBIPAddressDns1,
			string sPBIPAddressDns2, string sPBIPAddressDns3, string sPBIPAddressDns4,
			string sPBIPAddressDnsAlt1, string sPBIPAddressDnsAlt2,
			string sPBIPAddressDnsAlt3, string sPBIPAddressDnsAlt4,
			string sPBIPAddressWins1, string sPBIPAddressWins2,
			string sPBIPAddressWins3, string sPBIPAddressWins4,
			string sPBIPAddressWinsAlt1, string sPBIPAddressWinsAlt2,
			string sPBIPAddressWinsAlt3, string sPBIPAddressWinsAlt4,
			bool bPBIpHeaderCompression, bool bPBSwCompression, bool bPBSlip,
			bool bPBGPRS, string sPBFlowControl, string sPBCredit, string sPBExtraDial,
			bool bPBBefore, bool bPBAfter, bool bPBManually, bool bPBWait)
		{
			string sNumbers;
			string sSettings;
			string sPBIPAddress;
			string sPBIPAddresses;
			string sExtraInfo;

			int iPBBefore =0;
			int iPBAfter = 0;
			int iPBManually = 0;
			int iPBWait = 0;
			int iPBUseCountryAndAreaCodes = 0;
			int iPBDialAsLocalCall = 0;
			int iPBSpecificIpAddr = 0;
			int iPBSpecificNameServers = 0;
			int iPBIpHeaderCompression = 0;
			int iPBSwCompression = 0;
			int iPBSlip = 0;
			int iPBGPRS = 0;

			if (bPBBefore) iPBBefore = 1;
			if (bPBAfter) iPBAfter = 1;
			if (bPBManually) iPBManually = 1;
			if (bPBWait) iPBWait = 1;
			if (bPBUseCountryAndAreaCodes) iPBUseCountryAndAreaCodes = 1;
			if (bPBDialAsLocalCall) iPBDialAsLocalCall = 1;
			if (bPBSpecificIpAddr) iPBSpecificIpAddr = 1;
			if (bPBSpecificNameServers) iPBSpecificNameServers = 1;
			if (bPBIpHeaderCompression) iPBIpHeaderCompression = 1;
			if (bPBSwCompression) iPBSwCompression = 1;
			if (bPBSlip) iPBSlip = 1;
			if (bPBGPRS) iPBGPRS = 1;

			sNumbers = sPBCountryCode + "|" + sPBAreaCode + "|" + sPBLocalPhoneNumber + "|" + sPBDeviceName;
			sExtraInfo = sPBFlowControl + "|" + sPBCredit + "|" + sPBExtraDial + "|" + sPBDestination;
			sSettings = sPBSecBeforeHangup + "|" + sPBBaudRate + "|" + sPBByteSize + "|" + sPBParity + "|" + sPBStopBits;
			sPBIPAddress = sPBIPAddress1 + "|" + sPBIPAddress2 + "|" + sPBIPAddress3 + "|" + sPBIPAddress4;
			sPBIPAddresses = sPBIPAddressDns1 + "|" + sPBIPAddressDns2 + "|" + sPBIPAddressDns3 + "|" + sPBIPAddressDns4 
				+ "|" + sPBIPAddressDnsAlt1 + "|" + sPBIPAddressDnsAlt2 + "|" + sPBIPAddressDnsAlt3 + "|" + sPBIPAddressDnsAlt4 
				+ "|" + sPBIPAddressWins1 + "|" + sPBIPAddressWins2 + "|" + sPBIPAddressWins3 + "|" + sPBIPAddressWins4 
				+ "|" + sPBIPAddressWinsAlt1 + "|" + sPBIPAddressWinsAlt2 + "|" + sPBIPAddressWinsAlt3 + "|" + sPBIPAddressWinsAlt4;

			return sPBSet(sPBEntryName, sNumbers, sExtraInfo, sSettings, 
				iPBBefore, iPBAfter, iPBManually, iPBWait, 
				iPBUseCountryAndAreaCodes, iPBDialAsLocalCall, 
				iPBSpecificIpAddr, sPBIPAddress, 
				iPBSpecificNameServers, sPBIPAddresses, 
				iPBIpHeaderCompression, iPBSwCompression, 
				iPBSlip, iPBGPRS, clsMain.SapphireRASLicence);
		}

		public static int PBValidate(string sPBEntry)
		{
			return sPBValidate(sPBEntry);
		}

		public static int PBDelete(string sPBEntry)
		{
			return sPBDelete(sPBEntry,clsMain.SapphireRASLicence);
		}

		public static int PBRename(string sPBEntryOld, string sPBEntryNew)
		{
			return sPBRename(sPBEntryOld, sPBEntryNew,clsMain.SapphireRASLicence);
		}

		public static string PBDestinations()
		{
			string sDestNames = new String(' ',2048);
			sPBDestinations(sDestNames);
			sDestNames = sDestNames.TrimEnd(' ');
			sDestNames = sDestNames.TrimEnd(Convert.ToChar(0x0000));
			return sDestNames;
		}

		public static void RefreshNames()
		{
			string sNames;
			int iCount;
			int iEntries;

			// Set up the list of available connections
			iEntries = 0;
			sNames = PBNames(ref iEntries);
			string [] sNamesArray = sNames.Split('|');
			clsListItem [] oComboEntry = new clsListItem[iEntries + 1];
			clsMain.fSetDial.cboEntry.Items.Clear();
			clsMain.fSetDial.cboEntry.DisplayMember = "sText";
			clsMain.fSetDial.cboEntry.ValueMember = "iValue";
			clsMain.fSetPB.cboEntry.Items.Clear();
			clsMain.fSetPB.cboEntry.DisplayMember = "sText";
			clsMain.fSetPB.cboEntry.ValueMember = "iValue";

			for (iCount = 0; iCount < iEntries; iCount++)
			{
				oComboEntry[iCount] = new clsListItem();
				oComboEntry[iCount].iValue = iCount;
				oComboEntry[iCount].sText = sNamesArray[iCount];
				clsMain.fSetDial.cboEntry.Items.Add(oComboEntry[iCount]);
				clsMain.fSetPB.cboEntry.Items.Add(oComboEntry[iCount]);
			}
            if (iEntries == 0)
            {
                oComboEntry[0] = new clsListItem();
                oComboEntry[0].iValue = 0;
                oComboEntry[0].sText = "No Connections";
                clsMain.fSetDial.cboEntry.Items.Add(oComboEntry[0]);
                clsMain.fSetPB.cboEntry.Items.Add(oComboEntry[0]);
            }
            else
            {
                clsMain.fSetDial.cboEntry.SelectedIndex = 0;
                clsMain.fSetPB.cboEntry.SelectedIndex = 0;
                clsPB.SetPBValues(clsMain.fSetDial.cboEntry.Text);
            }
		}

		public static void RefreshDevices()
		{
			string sNames;
			int iCount;
			int iEntries;

			// Set up the list of available connections
			iEntries = 0;
			sNames = PBDevices(ref iEntries);
			string [] sDevices = sNames.Split('|');
			clsListItem [] oComboDevice = new clsListItem[iEntries + 1];
			clsMain.fSetPB.cboDevice.Items.Clear();
			clsMain.fSetPB.cboDevice.DisplayMember = "sText";
			clsMain.fSetPB.cboDevice.ValueMember = "iValue";
			clsMain.fSetPBGprs.cboDevice.Items.Clear();
			clsMain.fSetPBGprs.cboDevice.DisplayMember = "sText";
			clsMain.fSetPBGprs.cboDevice.ValueMember = "iValue";
			
			for (iCount = 0; iCount < iEntries; iCount++)
			{
				oComboDevice[iCount] = new clsListItem();
				oComboDevice[iCount].iValue = iCount;
				oComboDevice[iCount].sText = sDevices[iCount];
				clsMain.fSetPB.cboDevice.Items.Add(oComboDevice[iCount]);
				clsMain.fSetPBGprs.cboDevice.Items.Add(oComboDevice[iCount]);
			}
            if (iEntries > 0)
            {
                clsMain.fSetPB.cboDevice.SelectedIndex = 0;
                clsMain.fSetPBGprs.cboDevice.SelectedIndex = 0;
            }

			sNames = PBDestinations();
			string [] sDestinations = sNames.Split('|');
			clsListItem [] oComboDest = new clsListItem[sDestinations.GetUpperBound(0)];
			clsMain.fSetPB.cboDestination.Items.Clear();
			clsMain.fSetPB.cboDestination.DisplayMember = "sText";
			clsMain.fSetPB.cboDestination.ValueMember = "iValue";
			clsMain.fSetPBGprs.cboDestination.Items.Clear();
			clsMain.fSetPBGprs.cboDestination.DisplayMember = "sText";
			clsMain.fSetPBGprs.cboDestination.ValueMember = "iValue";
			
			for (iCount = 0; iCount < sDestinations.GetUpperBound(0); iCount++)
			{
				oComboDest[iCount] = new clsListItem();
				oComboDest[iCount].iValue = iCount;
				oComboDest[iCount].sText = sDestinations[iCount];
				clsMain.fSetPB.cboDestination.Items.Add(oComboDest[iCount]);
				clsMain.fSetPBGprs.cboDestination.Items.Add(oComboDest[iCount]);
			}
            if (sDestinations.GetUpperBound(0) > 0)
            {
                clsMain.fSetPB.cboDestination.SelectedIndex = 0;
                clsMain.fSetPBGprs.cboDestination.SelectedIndex = 0;
            }
		}

		public static void SetPBValues(string PBName)
		{
			string sEntry;

			clsMain.fSetPB.txtName.Text = PBName;
			sEntry = PBGet(PBName);

			string [] sDetails = sEntry.Split('|');

			if (sDetails.GetUpperBound(0) > 0)
			{
				clsMain.fSetPB.txtCountryCode.Text = sDetails[0];
				clsMain.fSetPB.txtAreaCode.Text = sDetails[1];
				clsMain.fSetPB.txtLocalPhoneNumber.Text = sDetails[2];
				clsMain.fSetPB.cboDevice.Text = sDetails[3];
				clsMain.fSetPB.cboDestination.Text = sDetails[4];
				clsMain.fSetPBAdv1.cboBaud.Text = sDetails[5];
				clsMain.fSetPBAdv1.cboBits.Text = sDetails[6];
				clsMain.fSetPBAdv1.cboParity.Text = sDetails[7];
				clsMain.fSetPBAdv1.cboStop.Text = sDetails[8];
				clsMain.fSetPBAdv4.txtTimeout.Text = sDetails[9];
				if (sDetails[10] == "1")
					clsMain.fSetPBAdv1.optIntCall.Checked = true;
				else
					clsMain.fSetPBAdv1.optIntCall.Checked = false;
				if (sDetails[11] == "1")
					clsMain.fSetPBAdv2.optSpecific.Checked = true;
				else
					clsMain.fSetPBAdv2.optServerAssigned.Checked = true;
		
				clsMain.fSetPBAdv2.txtIPAddress1.Text = sDetails[12];
				clsMain.fSetPBAdv2.txtIPAddress2.Text = sDetails[13];
				clsMain.fSetPBAdv2.txtIPAddress3.Text = sDetails[14];
				clsMain.fSetPBAdv2.txtIPAddress4.Text = sDetails[15];
				if (sDetails[16] == "1")
					clsMain.fSetPBAdv3.optSpecific.Checked = true;
				else
					clsMain.fSetPBAdv3.optServerAssigned.Checked = true;
				clsMain.fSetPBAdv3.txtDNSAddress1.Text = sDetails[17];
				clsMain.fSetPBAdv3.txtDNSAddress2.Text = sDetails[18];
				clsMain.fSetPBAdv3.txtDNSAddress3.Text = sDetails[19];
				clsMain.fSetPBAdv3.txtDNSAddress4.Text = sDetails[20];
				clsMain.fSetPBAdv3.txtAltDNSAddress1.Text = sDetails[21];
				clsMain.fSetPBAdv3.txtAltDNSAddress2.Text = sDetails[22];
				clsMain.fSetPBAdv3.txtAltDNSAddress3.Text = sDetails[23];
				clsMain.fSetPBAdv3.txtAltDNSAddress4.Text = sDetails[24];
				clsMain.fSetPBAdv3.txtWINSAddress1.Text = sDetails[25];
				clsMain.fSetPBAdv3.txtWINSAddress2.Text = sDetails[26];
				clsMain.fSetPBAdv3.txtWINSAddress3.Text = sDetails[27];
				clsMain.fSetPBAdv3.txtWINSAddress4.Text = sDetails[28];
				clsMain.fSetPBAdv3.txtAltWINSAddress1.Text = sDetails[29];
				clsMain.fSetPBAdv3.txtAltWINSAddress2.Text = sDetails[30];
				clsMain.fSetPBAdv3.txtAltWINSAddress3.Text = sDetails[31];
				clsMain.fSetPBAdv3.txtAltWINSAddress4.Text = sDetails[32];
				if (sDetails[33] == "1")
					clsMain.fSetPBAdv1.optLocalCall.Checked = true;
				else
					clsMain.fSetPBAdv1.optLocalCall.Checked = false;
				if (sDetails[34] == "1")
					clsMain.fSetPBAdv2.chkIPHeader.Checked = true;
				else
					clsMain.fSetPBAdv2.chkIPHeader.Checked = false;
				if (sDetails[35] == "1")
					clsMain.fSetPBAdv2.chkSoftware.Checked = true;
				else
					clsMain.fSetPBAdv2.chkSoftware.Checked = false;
				if (sDetails[36] == "1")
					clsMain.fSetPBAdv2.chkSlip.Checked = true;
				else
					clsMain.fSetPBAdv2.chkSlip.Checked = false;
				clsMain.fSetPBAdv1.cboFlowControl.Text = sDetails[37];
				clsMain.fSetPBAdv4.txtCredit.Text = sDetails[38];
				clsMain.fSetPBAdv4.txtExtraDial.Text = sDetails[39];
				if (sDetails[40] == "1")
					clsMain.fSetPBAdv4.chkBefore.Checked = true;
				else
					clsMain.fSetPBAdv4.chkBefore.Checked = false;
				if (sDetails[41] == "1")
					clsMain.fSetPBAdv4.chkAfter.Checked = true;
				else
					clsMain.fSetPBAdv4.chkAfter.Checked = false;
				if (sDetails[42] == "1")
					clsMain.fSetPBAdv4.chkManually.Checked = true;
				else
					clsMain.fSetPBAdv4.chkManually.Checked = false;
				if (sDetails[43] == "1")
					clsMain.fSetPBAdv4.chkWait.Checked = true;
				else
					clsMain.fSetPBAdv4.chkWait.Checked = false;
			}
		}

		public static void IPServerAssigned()
		{
			clsMain.fSetPBAdv2.txtIPAddress1.Enabled = false;
			clsMain.fSetPBAdv2.txtIPAddress2.Enabled = false;
			clsMain.fSetPBAdv2.txtIPAddress3.Enabled = false;
			clsMain.fSetPBAdv2.txtIPAddress4.Enabled = false;
		}

		public static void IPSpecific()
		{
			clsMain.fSetPBAdv2.txtIPAddress1.Enabled = true;
			clsMain.fSetPBAdv2.txtIPAddress2.Enabled = true;
			clsMain.fSetPBAdv2.txtIPAddress3.Enabled = true;
			clsMain.fSetPBAdv2.txtIPAddress4.Enabled = true;
		}

		public static void NameServerAssigned()
		{
			clsMain.fSetPBAdv3.txtDNSAddress1.Enabled = false;
			clsMain.fSetPBAdv3.txtDNSAddress2.Enabled = false;
			clsMain.fSetPBAdv3.txtDNSAddress3.Enabled = false;
			clsMain.fSetPBAdv3.txtDNSAddress4.Enabled = false;
			clsMain.fSetPBAdv3.txtAltDNSAddress1.Enabled = false;
			clsMain.fSetPBAdv3.txtAltDNSAddress2.Enabled = false;
			clsMain.fSetPBAdv3.txtAltDNSAddress3.Enabled = false;
			clsMain.fSetPBAdv3.txtAltDNSAddress4.Enabled = false;
			clsMain.fSetPBAdv3.txtWINSAddress1.Enabled = false;
			clsMain.fSetPBAdv3.txtWINSAddress2.Enabled = false;
			clsMain.fSetPBAdv3.txtWINSAddress3.Enabled = false;
			clsMain.fSetPBAdv3.txtWINSAddress4.Enabled = false;
			clsMain.fSetPBAdv3.txtAltWINSAddress1.Enabled = false;
			clsMain.fSetPBAdv3.txtAltWINSAddress2.Enabled = false;
			clsMain.fSetPBAdv3.txtAltWINSAddress3.Enabled = false;
			clsMain.fSetPBAdv3.txtAltWINSAddress4.Enabled = false;
		}

		public static void NameSpecific()
		{
			clsMain.fSetPBAdv3.txtDNSAddress1.Enabled = true;
			clsMain.fSetPBAdv3.txtDNSAddress2.Enabled = true;
			clsMain.fSetPBAdv3.txtDNSAddress3.Enabled = true;
			clsMain.fSetPBAdv3.txtDNSAddress4.Enabled = true;
			clsMain.fSetPBAdv3.txtAltDNSAddress1.Enabled = true;
			clsMain.fSetPBAdv3.txtAltDNSAddress2.Enabled = true;
			clsMain.fSetPBAdv3.txtAltDNSAddress3.Enabled = true;
			clsMain.fSetPBAdv3.txtAltDNSAddress4.Enabled = true;
			clsMain.fSetPBAdv3.txtWINSAddress1.Enabled = true;
			clsMain.fSetPBAdv3.txtWINSAddress2.Enabled = true;
			clsMain.fSetPBAdv3.txtWINSAddress3.Enabled = true;
			clsMain.fSetPBAdv3.txtWINSAddress4.Enabled = true;
			clsMain.fSetPBAdv3.txtAltWINSAddress1.Enabled = true;
			clsMain.fSetPBAdv3.txtAltWINSAddress2.Enabled = true;
			clsMain.fSetPBAdv3.txtAltWINSAddress3.Enabled = true;
			clsMain.fSetPBAdv3.txtAltWINSAddress4.Enabled = true;
		}

		public static int PBGetWorkInternet()
		{
			return sPBGetWorkInternet();
		}

		public static int PBSetWorkInternet(int iNumber)
		{
			return sPBSetWorkInternet(iNumber);
		}

		public static int PBSetDefault(string sPBEntry)
		{
			return sPBSetDefault(sPBEntry, clsMain.SapphireRASLicence);
		}

		public static void SetPBSettings()
		{
			string sEntry;

			clsRAS.sUserPass = false;
			clsRAS.sConnectionEntry = clsMain.fSetDial.cboEntry.Text;
			sEntry = clsRAS.RASGetParams(clsRAS.sConnectionEntry);
			string [] sEntries = sEntry.Split('|');
			if (sEntries.GetUpperBound(0) > 0)
			{
				clsRAS.sUsername = sEntries[0];
				clsMain.fSetDial.txtUsername.Text = clsRAS.sUsername;
				clsRAS.sPassword = sEntries[1];
				clsMain.fSetDial.txtPassword.Text = clsRAS.sPassword;
				clsRAS.sDomain = sEntries[2];
				clsMain.fSetDial.txtDomain.Text = clsRAS.sDomain;
			}
		}
	}
}
