using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace RASDemo
{
	/// <summary>
	/// Summary description for frmRASDialAsync.
	/// </summary>
	public class frmRASDialAsync : System.Windows.Forms.Form
	{
		// Determine the handle to the Application window. 
		public int hDC = clsMain.FindWindow(null, "frmRASDialASync");
		internal System.Windows.Forms.Label lblHelp;
		internal System.Windows.Forms.Button cmdHangUp;
		internal System.Windows.Forms.Button cmdDial;
		internal System.Windows.Forms.Button cmdBack;
		internal System.Windows.Forms.Label lblModem;
		private System.Windows.Forms.MainMenu mainMenu1;
		public System.Windows.Forms.Timer tmrStatus; 
		int iNot;

		public frmRASDialAsync()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>

		private void InitializeComponent()
		{
			this.lblHelp = new System.Windows.Forms.Label();
			this.cmdHangUp = new System.Windows.Forms.Button();
			this.cmdDial = new System.Windows.Forms.Button();
			this.cmdBack = new System.Windows.Forms.Button();
			this.lblModem = new System.Windows.Forms.Label();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.tmrStatus = new System.Windows.Forms.Timer();
			// 
			// lblHelp
			// 
			this.lblHelp.Location = new System.Drawing.Point(8, 168);
			this.lblHelp.Size = new System.Drawing.Size(224, 56);
			this.lblHelp.Text = "Notes: Async dial-up uses a timer so that the on-going status of the connection c" +
				"an be viewed whilst connection  is in progress.";
			this.lblHelp.TextAlign = System.Drawing.ContentAlignment.TopCenter;
			// 
			// cmdHangUp
			// 
			this.cmdHangUp.Location = new System.Drawing.Point(32, 120);
			this.cmdHangUp.Size = new System.Drawing.Size(176, 32);
			this.cmdHangUp.Text = "Hang Up";
			this.cmdHangUp.Click += new System.EventHandler(this.cmdHangUp_Click);
			// 
			// cmdDial
			// 
			this.cmdDial.Location = new System.Drawing.Point(32, 72);
			this.cmdDial.Size = new System.Drawing.Size(176, 32);
			this.cmdDial.Text = "Dial Up";
			this.cmdDial.Click += new System.EventHandler(this.cmdDial_Click);
			// 
			// cmdBack
			// 
			this.cmdBack.Location = new System.Drawing.Point(144, 240);
			this.cmdBack.Size = new System.Drawing.Size(88, 24);
			this.cmdBack.Text = "Back";
			this.cmdBack.Click += new System.EventHandler(this.cmdBack_Click);
			// 
			// lblModem
			// 
			this.lblModem.Location = new System.Drawing.Point(8, 8);
			this.lblModem.Size = new System.Drawing.Size(224, 56);
			this.lblModem.Text = "Modem: Ready";
			// 
			// tmrStatus
			// 
			this.tmrStatus.Interval = 200;
			this.tmrStatus.Tick += new System.EventHandler(this.tmrStatus_Tick);
			// 
			// frmRASDialAsync
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.lblHelp);
			this.Controls.Add(this.cmdHangUp);
			this.Controls.Add(this.cmdDial);
			this.Controls.Add(this.cmdBack);
			this.Controls.Add(this.lblModem);
			this.Menu = this.mainMenu1;
			this.Text = "RAS Async";

		}
		#endregion

		private void cmdDial_Click(object sender, System.EventArgs e)
		{
			int iStatus;
			int iResult;
			string sEntry;
			string sStoredUsername;
			string sStoredPassword;

	        clsRAS.RASStatus();
			clsRAS.RASHangUp();
			iStatus = clsRAS.RASStatus();
			if (iStatus == 0)
			{
				sStoredUsername = "";
				sStoredPassword = "";

				// Get the stored Username and Password for this connection
				sEntry = clsRAS.RASGetParams(clsRAS.sConnectionEntry);
				string [] sEntries = sEntry.Split('|');
				if (sEntries.GetUpperBound(0) > 0)
				{
					sStoredUsername = sEntries[0];
					sStoredPassword = sEntries[1];
				}

				if (sStoredUsername == "" && clsRAS.sUsername == "" && clsRAS.sUserPass == true)
				{
					clsRAS.sUsername = Microsoft.VisualBasic.Interaction.InputBox("Enter Connection User Name","RASDemo","",10,10);
					if (clsRAS.sUsername == "")
					{
						if (MessageBox.Show("Continue without Username?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
							return;
					} 
				}

				if (sStoredPassword == "" && clsRAS.sPassword == "" && clsRAS.sUserPass == true)
				{
					clsRAS.sPassword = Microsoft.VisualBasic.Interaction.InputBox("Enter Connection Password","RASDemo","",10,10);
					if (clsRAS.sPassword == "")
					{
						if (MessageBox.Show("Continue without Password?", "RASDemo", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.No)
							return;							
					}
				}

				lblModem.Text = "Modem: Dialing Please Wait";
				lblModem.Refresh();
				// Pass the handle for the current form so that error messages from the DLL are displayed on this form.
				iResult = clsRAS.RASDial(hDC);

				if (iResult == 0)
				{
					tmrStatus.Enabled = true;
					cmdDial.Enabled = false;
					cmdHangUp.Enabled = true;
					iNot = 0;
				}
				else
				{
					lblModem.Text = "Modem: Error-" + clsRAS.RASErrMsg(iResult);
					lblModem.Refresh();
					HangUp();
				}
			}
		}

		private void cmdHangUp_Click(object sender, System.EventArgs e)
		{
			HangUp();
		}

		private void HangUp()
		{
			int iStatus;
			int iResult;

			tmrStatus.Enabled = false;
			iStatus = clsRAS.RASStatus();
			if (iStatus != 0)
			{
				lblModem.Text = "Modem: Disconnecting Modem";
				lblModem.Refresh();
				iResult = clsRAS.RASHangUp();
				if (iResult == 0)
				{
					lblModem.Text = "Modem: Ready";
					lblModem.Refresh();
					cmdDial.Enabled = true;
					cmdHangUp.Enabled = false;
				}
				else
				{
					lblModem.Text = "Modem: Error-" + clsRAS.RASErrMsg(iResult);
					lblModem.Refresh();
				}
			}
			else
			{
				lblModem.Text = "Modem: Ready";
				lblModem.Refresh();
				cmdDial.Enabled = true;
				cmdHangUp.Enabled = false;
			}
		}

		private void cmdBack_Click(object sender, System.EventArgs e)
		{
			clsMain.fRASDial.Show();
			this.Hide();
		}
    
		public void loadRASDial()
		{
			string sCurrentConn;

			clsMain.fRASDialAsync.lblModem.Text = "Modem: Ready";
			clsMain.fRASDialAsync.lblModem.Refresh();
			// Show the current connection if present.
			sCurrentConn = clsRAS.RASCurrentConn();
			if (sCurrentConn != "")
			{
				clsRAS.sConnectionEntry = sCurrentConn;
				clsMain.fSetDial.cboEntry.Text = clsRAS.sConnectionEntry;
				clsMain.fRASDialAsync.tmrStatus.Enabled = true;
				clsMain.fRASDialAsync.cmdDial.Enabled = false;
				clsMain.fRASDialAsync.cmdHangUp.Enabled = true;
			}
			else
			{
				clsMain.fRASDialAsync.cmdDial.Enabled = true;
				clsMain.fRASDialAsync.cmdHangUp.Enabled = false;
			}
		}

		private void tmrStatus_Tick(object sender, System.EventArgs e)
		{
			int iResult;
			int iStatus;
			string sStatus;
			bool bLoop;

			tmrStatus.Enabled = false;
			bLoop = true;

			iStatus = 0;
			// Check and report connection status every 200ms
			iStatus = clsRAS.RASStatus();
			switch(iStatus)
			{
				case 25: // Lost Connection
					iResult = clsRAS.RASHangUp();
					cmdDial.Enabled = true;
					cmdHangUp.Enabled = false;
					bLoop = false;
					break;
				case 1: // Connected
					bLoop = false;
					break;
			}

			sStatus = clsRAS.RASStatusMsg(iStatus);
			lblModem.Text = "Modem: " + sStatus + " " + clsRAS.RASCurrentConn();
			lblModem.Refresh();

			if (iStatus == 25)
				HangUp();

			if (iStatus == 1)
	            //StartFTP()

			if (iStatus == 0)
				HangUp();

			if (iStatus == 0)
				iNot++;

			if (iNot > 20)
			{
				bLoop = false;
				HangUp();
			}

			if (bLoop == true)
				tmrStatus.Enabled = true;
		}
	}
}
