using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace RASDemo
{
	/// <summary>
	/// Summary description for frmSetDial.
	/// </summary>
	public class frmSetDial : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.RadioButton optInternet;
		internal System.Windows.Forms.RadioButton optWork;
		internal System.Windows.Forms.Label lblQuestion;
		internal System.Windows.Forms.Button cmdApply;
		internal System.Windows.Forms.Button cmdBack;
		internal System.Windows.Forms.Button cmdDefault;
		internal System.Windows.Forms.Panel Panel1;
		internal System.Windows.Forms.RadioButton optUserPassNo;
		internal System.Windows.Forms.RadioButton optUserPassYes;
		internal System.Windows.Forms.TextBox txtDomain;
		internal System.Windows.Forms.TextBox txtPassword;
		internal System.Windows.Forms.TextBox txtUsername;
		internal System.Windows.Forms.Label lblDomain;
		internal System.Windows.Forms.Label lblPassword;
		internal System.Windows.Forms.Label lblUsername;
		internal System.Windows.Forms.ComboBox cboEntry;
		internal System.Windows.Forms.Label lblName;
		private System.Windows.Forms.MainMenu mainMenu1;
		private Microsoft.WindowsCE.Forms.InputPanel inputPanel1;
		internal System.Windows.Forms.Label lblNetwork;
	
		public frmSetDial()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.optInternet = new System.Windows.Forms.RadioButton();
			this.optWork = new System.Windows.Forms.RadioButton();
			this.lblQuestion = new System.Windows.Forms.Label();
			this.cmdApply = new System.Windows.Forms.Button();
			this.cmdBack = new System.Windows.Forms.Button();
			this.cmdDefault = new System.Windows.Forms.Button();
			this.Panel1 = new System.Windows.Forms.Panel();
			this.optUserPassNo = new System.Windows.Forms.RadioButton();
			this.optUserPassYes = new System.Windows.Forms.RadioButton();
			this.txtDomain = new System.Windows.Forms.TextBox();
			this.txtPassword = new System.Windows.Forms.TextBox();
			this.txtUsername = new System.Windows.Forms.TextBox();
			this.lblDomain = new System.Windows.Forms.Label();
			this.lblPassword = new System.Windows.Forms.Label();
			this.lblUsername = new System.Windows.Forms.Label();
			this.cboEntry = new System.Windows.Forms.ComboBox();
			this.lblName = new System.Windows.Forms.Label();
			this.lblNetwork = new System.Windows.Forms.Label();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.inputPanel1 = new Microsoft.WindowsCE.Forms.InputPanel();
			// 
			// optInternet
			// 
			this.optInternet.Location = new System.Drawing.Point(128, 160);
			this.optInternet.Size = new System.Drawing.Size(96, 16);
			this.optInternet.Text = "Internet";
			// 
			// optWork
			// 
			this.optWork.Location = new System.Drawing.Point(8, 160);
			this.optWork.Size = new System.Drawing.Size(104, 16);
			this.optWork.Text = "Work";
			// 
			// lblQuestion
			// 
			this.lblQuestion.Location = new System.Drawing.Point(8, 192);
			this.lblQuestion.Size = new System.Drawing.Size(112, 16);
			this.lblQuestion.Text = "User/Pass Required?";
			// 
			// cmdApply
			// 
			this.cmdApply.Location = new System.Drawing.Point(128, 240);
			this.cmdApply.Size = new System.Drawing.Size(104, 24);
			this.cmdApply.Text = "Apply";
			this.cmdApply.Click += new System.EventHandler(this.cmdApply_Click);
			// 
			// cmdBack
			// 
			this.cmdBack.Location = new System.Drawing.Point(8, 240);
			this.cmdBack.Size = new System.Drawing.Size(104, 24);
			this.cmdBack.Text = "Back";
			this.cmdBack.Click += new System.EventHandler(this.cmdBack_Click);
			// 
			// cmdDefault
			// 
			this.cmdDefault.Location = new System.Drawing.Point(128, 200);
			this.cmdDefault.Size = new System.Drawing.Size(104, 24);
			this.cmdDefault.Text = "Set as Defaults";
			this.cmdDefault.Click += new System.EventHandler(this.cmdDefault_Click);
			// 
			// Panel1
			// 
			this.Panel1.Controls.Add(this.optUserPassNo);
			this.Panel1.Controls.Add(this.optUserPassYes);
			this.Panel1.Location = new System.Drawing.Point(8, 200);
			this.Panel1.Size = new System.Drawing.Size(104, 32);
			// 
			// optUserPassNo
			// 
			this.optUserPassNo.Location = new System.Drawing.Point(56, 8);
			this.optUserPassNo.Size = new System.Drawing.Size(40, 16);
			this.optUserPassNo.Text = "No";
			// 
			// optUserPassYes
			// 
			this.optUserPassYes.Location = new System.Drawing.Point(8, 8);
			this.optUserPassYes.Size = new System.Drawing.Size(48, 16);
			this.optUserPassYes.Text = "Yes";
			// 
			// txtDomain
			// 
			this.txtDomain.Location = new System.Drawing.Point(80, 112);
			this.txtDomain.Size = new System.Drawing.Size(152, 20);
			this.txtDomain.Text = "";
			// 
			// txtPassword
			// 
			this.txtPassword.Location = new System.Drawing.Point(80, 80);
			this.txtPassword.PasswordChar = '*';
			this.txtPassword.Size = new System.Drawing.Size(152, 20);
			this.txtPassword.Text = "";
			// 
			// txtUsername
			// 
			this.txtUsername.Location = new System.Drawing.Point(80, 48);
			this.txtUsername.Size = new System.Drawing.Size(152, 20);
			this.txtUsername.Text = "";
			// 
			// lblDomain
			// 
			this.lblDomain.Location = new System.Drawing.Point(8, 112);
			this.lblDomain.Size = new System.Drawing.Size(64, 16);
			this.lblDomain.Text = "Domain:";
			// 
			// lblPassword
			// 
			this.lblPassword.Location = new System.Drawing.Point(8, 80);
			this.lblPassword.Size = new System.Drawing.Size(64, 16);
			this.lblPassword.Text = "Password:";
			// 
			// lblUsername
			// 
			this.lblUsername.Location = new System.Drawing.Point(8, 48);
			this.lblUsername.Size = new System.Drawing.Size(64, 16);
			this.lblUsername.Text = "Username:";
			// 
			// cboEntry
			// 
			this.cboEntry.Location = new System.Drawing.Point(80, 16);
			this.cboEntry.Size = new System.Drawing.Size(152, 21);
			this.cboEntry.SelectedIndexChanged += new System.EventHandler(this.cboEntry_SelectedIndexChanged);
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 16);
			this.lblName.Size = new System.Drawing.Size(64, 16);
			this.lblName.Text = "Name:";
			// 
			// lblNetwork
			// 
			this.lblNetwork.Location = new System.Drawing.Point(8, 144);
			this.lblNetwork.Size = new System.Drawing.Size(224, 16);
			this.lblNetwork.Text = "My Network card connects to:";
			// 
			// frmSetDial
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.optInternet);
			this.Controls.Add(this.optWork);
			this.Controls.Add(this.lblQuestion);
			this.Controls.Add(this.cmdApply);
			this.Controls.Add(this.cmdBack);
			this.Controls.Add(this.cmdDefault);
			this.Controls.Add(this.Panel1);
			this.Controls.Add(this.txtDomain);
			this.Controls.Add(this.txtPassword);
			this.Controls.Add(this.txtUsername);
			this.Controls.Add(this.lblDomain);
			this.Controls.Add(this.lblPassword);
			this.Controls.Add(this.lblUsername);
			this.Controls.Add(this.cboEntry);
			this.Controls.Add(this.lblName);
			this.Controls.Add(this.lblNetwork);
			this.Menu = this.mainMenu1;
			this.Text = "Set Dial-up";

		}
		#endregion

		private void cmdApply_Click(object sender, System.EventArgs e)
		{
	        //Set this as the current connection.
			clsRAS.sConnectionEntry = cboEntry.Text;
			clsRAS.sUsername = txtUsername.Text;
			clsRAS.sPassword = txtPassword.Text;
			clsRAS.sDomain = txtDomain.Text;
			if (optUserPassYes.Checked == true)
				clsRAS.sUserPass = true;
			else
				clsRAS.sUserPass = false;
        
			if (optWork.Checked == true)
				clsPB.PBSetWorkInternet(1);
			else
				clsPB.PBSetWorkInternet(2);

	        clsMain.fRASMenu.Show();
			this.Hide();
		}

		private void cmdBack_Click(object sender, System.EventArgs e)
		{
			clsMain.fRASMenu.Show();
			this.Hide();
		}

		private void cmdDefault_Click(object sender, System.EventArgs e)
		{
			int iResult;

			// Store this connection as the default.
			iResult = clsPB.PBSetDefault(cboEntry.Text);
			if (iResult != 0)
				MessageBox.Show(clsRAS.RASErrMsg(iResult));

			// Store displayed settings as the defaults for this connection.
			iResult = clsRAS.RASSetParams(cboEntry.Text, txtUsername.Text, txtPassword.Text, txtDomain.Text);
			if (iResult != 0)
				MessageBox.Show(clsRAS.RASErrMsg(iResult));
		}

		private void cboEntry_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			string sEntry;

			// Get and display the default parameters for this connection.
			if (cboEntry.SelectedIndex != -1)
			{
				sEntry = clsRAS.RASGetParams(cboEntry.Text);
				string [] sEntries = sEntry.Split('|');
				if (sEntries.GetUpperBound(0) > 0)
				{
					txtUsername.Text = sEntries[0];
					txtPassword.Text = sEntries[1];
					txtDomain.Text = sEntries[2];
				}
			}
		}

		public void loadSetDial()
		{
			if (clsRAS.sUserPass == true)
				optUserPassYes.Checked = true;
			else
				optUserPassNo.Checked = true;

			if (clsPB.PBGetWorkInternet() == 1)
				optWork.Checked = true;
			else
				optInternet.Checked = true;
		}
	}
}
