Imports System.Threading.Thread
Imports System.Runtime.InteropServices

Module RAS
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASDial(ByVal sEntryName As String, ByVal sUsername As String, ByVal sPassword As String, ByVal sDomain As String, ByRef hRasConn As Integer, ByRef hDC As Integer, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASDialOnly(ByVal sEntryName As String, ByVal sUsername As String, ByVal sPassword As String, ByVal sDomain As String, ByRef hRasConn As Integer, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASGetParams(ByVal sEntryName As String, ByVal sRASNames As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASSetParams(ByVal sEntryName As String, ByVal sUsername As String, ByVal sPassword As String, ByVal sDomain As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASHangUp(ByVal hRasConn As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASCurrentConn(ByRef hRasConn As Integer, ByVal sConnName As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASStatus(ByVal hRasConn As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Sub sRASStatusMsg(ByVal sStatusText As String, ByVal iStatus As Integer)
    End Sub
    <DllImport("SapphireRAS.dll")> _
    Public Sub sRASErrMsg(ByVal sErrorText As String, ByVal iError As Integer)
    End Sub
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASAutoDial(ByRef hRasConn As Integer, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sRASAutoHangup(ByVal hRasConn As Integer) As Integer
    End Function

    ' Dial Settings
    Public sConnectionEntry As String
    Public sUsername As String
    Public sPassword As String
    Public sDomain As String
    Public sUserPass As Boolean
    Public iConnection As Integer ' Global Connection Handle, Passed Back to Disconnection and Status
    Public iRASConn As Integer ' Global Connection Handle, Passed Back to Disconnection and Status

    Public Function RASDial(ByVal hDC As Integer) As Integer
        RASDial = sRASDial(sConnectionEntry, sUsername, sPassword, sDomain, iConnection, hDC, SapphireRASLicence)
        ' Set sConnectionEntry equal to your dial-up connection name
        ' Set SapphireRASLicence with your Licence Number unless Demo DLL
        ' hDC is passed into this function from the current forms Window handle
    End Function

    Public Function RASDialOnly() As Integer
        RASDialOnly = sRASDialOnly(sConnectionEntry, sUsername, sPassword, sDomain, iConnection, SapphireRASLicence)
        ' Set sConnectionEntry equal to your dial-up connection name
        ' Set SapphireRASLicence with your Licence Number unless Demo DLL
    End Function

    Public Function RASGetParams(ByVal sRASEntry As String) As String
        Dim sRASNames As String = Space(2048)
        sRASGetParams(sRASEntry, sRASNames)
        RASGetParams = StripString(sRASNames)
    End Function

    Public Function RASSetParams(ByVal sRASEntry As String, ByVal sRASUsername As String, ByVal sRASPassword As String, ByVal sRASDomain As String) As Integer
        RASSetParams = sRASSetParams(sRASEntry, sRASUsername, sRASPassword, sRASDomain)
    End Function

    Public Function RASHangUp() As Integer
        RASHangUp = sRASHangUp(iConnection)
    End Function

    Public Function RASStatus() As Integer
        RASStatus = sRASStatus(iConnection)
    End Function

    Public Function RASStatusMsg(ByVal iStatus As Integer) As String
        Dim sStatusText As String = Space(1024)
        sRASStatusMsg(sStatusText, iStatus)
        RASStatusMsg = StripString(sStatusText)
    End Function

    Public Function RASErrMsg(ByVal iError As Integer) As String
        Dim sErrorText As String = Space(1024)
        sRASErrMsg(sErrorText, iError)
        RASErrMsg = StripString(sErrorText)
    End Function

    Public Function RASCurrentConn() As String
        Dim sConnName As String = Space(40)
        sRASCurrentConn(iConnection, sConnName)
        RASCurrentConn = StripString(sConnName)
    End Function

    Public Function RASAutoDial() As Integer
        RASAutoDial = sRASAutoDial(iRASConn, SapphireRASLicence)
    End Function

    Public Function RASAutoHangup() As Integer
        RASAutoHangup = sRASAutoHangup(iRASConn)
        RASCurrentConn()
        RASHangUp()
    End Function
End Module
