using System;
using System.Runtime.InteropServices;

namespace RASDemo
{
	/// <summary>
	/// Summary description for clsRAS.
	/// </summary>
	public class clsRAS
	{
		[DllImport("SapphireRAS.dll")]
		public static extern int sRASDial(string sEntryName, string sUsername, string sPassword, string sDomain, ref int hRasConn, ref int hDC, int iLicence);

		[DllImport("SapphireRAS.dll")]
		public static extern int sRASDialOnly(string sEntryName,string sUsername,string sPassword, string sDomain,ref int hRasConn,int iLicence);

		[DllImport("SapphireRAS.dll")]
		public static extern int sRASHangUp(int hRasConn);

		[DllImport("SapphireRAS.dll")]
		public static extern int sRASStatus(int hRasConn);
		
		[DllImport("SapphireRAS.dll")]
		public static extern int sRASGetParams(string sEntryName, string sRASNames);
		
		[DllImport("SapphireRAS.dll")]
		public static extern int sRASSetParams(string sEntryName, string sUsername, string sPassword, string sDomain);

		[DllImport("SapphireRAS.dll")]
		public static extern void sRASStatusMsg(string sStatusText, int iStatus);
		
		[DllImport("SapphireRAS.dll")]
		public static extern void sRASErrMsg(string sErrorText, int iError);

		[DllImport("SapphireRAS.dll")]
		public static extern int sRASCurrentConn(ref int hRasConn, string sConnName);

		[DllImport("SapphireRAS.dll")]
		public static extern int sRASAutoDial(ref int hRasConn, int iLicence);

		[DllImport("SapphireRAS.dll")]
		public static extern int sRASAutoHangup(int hRasConn);


		// Dial Settings
		public static string sConnectionEntry;
		public static string sUsername;
		public static string sPassword;
		public static string sDomain;
		public static bool sUserPass;
		public static int iConnection; // Global Connection Handle, Passed Back to Disconnection and Status
		public static int iRASConn; // Global Connection Handle, Passed Back to Disconnection and Status

		public clsRAS()
		{
		}

		public static int RASDial(int hDC)
		{
			return sRASDial(sConnectionEntry, sUsername, sPassword, sDomain, ref iConnection, ref hDC, clsMain.SapphireRASLicence);
			// Set sConnectionEntry equal to your dial-up connection name
			// Set SapphireRASLicence with your Licence Number unless Demo DLL
			// hDC is passed into this function from the current forms Window handle
		}

		public static int RASDialOnly()
		{
			return sRASDialOnly(sConnectionEntry, sUsername, sPassword, sDomain, ref iConnection, clsMain.SapphireRASLicence);
			// Set sConnectionEntry equal to your dial-up connection name
			// Set SapphireRASLicence with your Licence Number unless Demo DLL
		}

		public static int RASHangUp()
		{
			return sRASHangUp(iConnection);
		}

		public static int RASStatus()
		{
			return sRASStatus(iConnection);
		}

		public static string RASStatusMsg(int iStatus)
		{
			string sStatusText = new String(' ',1024);
			sRASStatusMsg(sStatusText, iStatus);
			sStatusText = sStatusText.TrimEnd(' ');
			sStatusText = sStatusText.TrimEnd(Convert.ToChar(0x0000));
			return sStatusText;
		}

		public static string RASErrMsg(int iError)
		{
			string sErrorText = new String(' ',1024);
			sRASErrMsg(sErrorText, iError);
			sErrorText = sErrorText.TrimEnd(' ');
			sErrorText = sErrorText.TrimEnd(Convert.ToChar(0x0000));
			return sErrorText;
		}

		public static string RASCurrentConn()
		{
			string sConnName = new String(' ',40);
			sRASCurrentConn(ref iConnection, sConnName);
			sConnName = sConnName.TrimEnd(' ');
			sConnName = sConnName.TrimEnd(Convert.ToChar(0x0000));
			return sConnName;
		}

		public static string RASGetParams(string sRASEntry)
		{
			string sRASNames = new String(' ',2048);
			sRASGetParams(sRASEntry, sRASNames);
			sRASNames = sRASNames.TrimEnd(' ');
			sRASNames = sRASNames.TrimEnd(Convert.ToChar(0x0000));
			return sRASNames;
		}

		public static int RASSetParams(string sRASEntry, string sRASUsername, string sRASPassword, string sRASDomain)
		{
			return sRASSetParams(sRASEntry, sRASUsername, sRASPassword, sRASDomain);
		}

		public static int RASAutoDial()
		{
			return sRASAutoDial(ref iRASConn, clsMain.SapphireRASLicence);
		}

		public static int RASAutoHangup()
		{
			int iReturn = 0;
			iReturn = sRASAutoHangup(iRASConn);
			RASCurrentConn();
			RASHangUp();
			return iReturn;
		}
	}
}
