Imports System.Threading.Thread
Imports System.Runtime.InteropServices

Module Location
    <DllImport("SapphireRAS.dll")> _
    Public Function sLOCGetCurrent() As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sLOCSetCurrent(ByVal iNumber As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sLOCGetNumber() As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sLOCSetNumber(ByVal iNumber As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sLOCGetLocation(ByVal iNumber As Integer, ByVal sLocations As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sLOCSetLocation(ByVal iNumber As Integer, ByVal sSettings As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Public Function sLOCDeleteLocation(ByVal iNumber As Integer) As Integer
    End Function

    Public Function LOCGetCurrent() As Integer
        LOCGetCurrent = sLOCGetCurrent()
    End Function

    Public Function LOCSetCurrent(ByVal iNumber As Integer) As Integer
        LOCSetCurrent = sLOCSetCurrent(iNumber)
    End Function

    Public Function LOCGetNumber() As Integer
        LOCGetNumber = sLOCGetNumber()
    End Function

    Public Function LOCSetNumber(ByVal iNumber As Integer) As Integer
        LOCSetNumber = sLOCSetNumber(iNumber)
    End Function

    Public Function LOCGetLocation(ByVal iNumber As Integer) As String
        Dim sLocations As String = Space(2048)
        sLOCGetLocation(iNumber, sLocations)
        LOCGetLocation = StripString(sLocations)
    End Function

    Public Function LOCSetLocation(ByVal iNumber As Integer, ByVal sName As String, ByVal sLocal As String, _
    ByVal sLong As String, ByVal sInternational As String, ByVal sArea As String, ByVal sCountry As String) As Integer
        Dim sSettings As String
        Dim sCallWaiting As String
        Dim sTone As String

        sCallWaiting = "" ' Call Waiting disable string
        sTone = "0" ' 0 = Tone Dialling ; 1 = Pulse Dialling
        sSettings = sName & "|" & sLocal & "|" & sLong & "|" & sInternational & "|" & sArea & "|" & sCallWaiting & "|" & sCountry & "|" & sTone & "|"
        LOCSetLocation = sLOCSetLocation(iNumber, sSettings)
    End Function

    Public Function LOCDeleteLocation(ByVal iNumber As Integer) As Integer
        LOCDeleteLocation = sLOCDeleteLocation(iNumber)
    End Function

    Public Sub RefreshLocations()
        Dim sEntry As String
        Dim iNumber As Integer
        Dim iCount As Integer

        iNumber = LOCGetNumber()
        fSetLocation.cboName.Items.Clear()
        For iCount = 0 To iNumber - 1
            sEntry = LOCGetLocation(iCount)
            Dim sEntries() As String = Split(sEntry, "|", -1)
            If UBound(sEntries) > 0 Then
                fSetLocation.cboName.Items.Add(New ListItem(sEntries(0), iCount))
            End If
        Next iCount
    End Sub

    Public Sub SetLOCName(ByVal iNumber As Integer)
        Dim sEntry As String
        Dim iCount As Integer

        sEntry = LOCGetLocation(iNumber)
        Dim sEntries() As String = Split(sEntry, "|", -1)
        If UBound(sEntries) > 0 Then
            For iCount = 0 To fSetLocation.cboName.Items.Count - 1
                If CType(fSetLocation.cboName.Items.Item(iCount), ListItem).Value = iNumber Then
                    fSetLocation.cboName.SelectedItem = fSetLocation.cboName.Items.Item(iCount)
                    Exit For
                End If
            Next iCount
        End If
    End Sub

    Public Sub SetLOCValues(ByVal iNumber As Integer)
        Dim sEntry As String

        sEntry = LOCGetLocation(iNumber)
        Dim sEntries() As String = Split(sEntry, "|", -1)
        If UBound(sEntries) > 0 Then
            fSetLocation.txtName.Text = sEntries(0)
            fSetLocation.txtLocal.Text = sEntries(1)
            fSetLocation.txtLong.Text = sEntries(2)
            fSetLocation.txtInternational.Text = sEntries(3)
            fSetLocation.txtArea.Text = sEntries(4)
            ' sEntries(5) ' Disable Call Waiting disable string
            fSetLocation.txtCountry.Text = sEntries(6)
            ' sEntries(7) ' 0 for Tone Dialing ; 1 for Pulse Dialing
        End If
    End Sub
End Module
