Imports System.Threading.Thread
Imports System.Runtime.InteropServices

Module PB
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBGet(ByVal sEntryName As String, ByVal sPBData As String, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBSet(ByVal sEntryName As String, _
            ByVal sNumbers As String, ByVal sExtraInfo As String, ByVal sSettings As String, _
            ByVal iPBBefore As Integer, ByVal iPBAfter As Integer, _
            ByVal iPBManually As Integer, ByVal iPBWait As Integer, _
            ByVal iUseCountryAndAreaCodes As Integer, ByVal iDialAsLocalCall As Integer, _
            ByVal iSpecificIpAddr As Integer, ByVal sIPAddress As String, _
            ByVal iSpecificNameServers As Integer, ByVal sIPAddresses As String, _
            ByVal iIpHeaderCompression As Integer, ByVal iSwCompression As Integer, _
            ByVal iSlip As Integer, ByVal iGPRS As Integer, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBValidate(ByVal sEntryName As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBDelete(ByVal sEntryName As String, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBRename(ByVal sOldEntryName As String, ByVal sNewEntryName As String, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBNames(ByRef iEntries As Integer, ByVal sRASNames As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBDevices(ByRef iEntries As Integer, ByVal sDevNames As String) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBGetWorkInternet() As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBSetWorkInternet(ByVal iNumber As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBSetDefault(ByVal sEntryName As String, ByVal iLicence As Integer) As Integer
    End Function
    <DllImport("SapphireRAS.dll")> _
    Friend Function sPBDestinations(ByVal sDestNames As String) As Integer
    End Function

    Friend Function PBGet(ByVal sPBEntry As String) As String
        Dim sPBData As String = Space(1024)
        sPBGet(sPBEntry, sPBData, SapphireRASLicence)
        PBGet = StripString(sPBData)
    End Function

    Friend Function PBSet(ByVal sPBEntryName As String, ByVal sPBCountryCode As String, ByVal sPBAreaCode As String, _
    ByVal sPBLocalPhoneNumber As String, ByVal sPBDeviceName As String, ByVal sPBDestination As String, _
    ByVal sPBBaudRate As String, ByVal sPBByteSize As String, ByVal sPBParity As String, _
    ByVal sPBStopBits As String, ByVal sPBSecBeforeHangup As String, _
    ByVal bPBUseCountryAndAreaCodes As Boolean, ByVal bPBDialAsLocalCall As Boolean, _
    ByVal bPBSpecificIpAddr As Boolean, ByVal sPBIPAddress1 As String, _
    ByVal sPBIPAddress2 As String, ByVal sPBIPAddress3 As String, _
    ByVal sPBIPAddress4 As String, ByVal bPBSpecificNameServers As Boolean, _
    ByVal sPBIPAddressDns1 As String, ByVal sPBIPAddressDns2 As String, _
    ByVal sPBIPAddressDns3 As String, ByVal sPBIPAddressDns4 As String, _
    ByVal sPBIPAddressDnsAlt1 As String, ByVal sPBIPAddressDnsAlt2 As String, _
    ByVal sPBIPAddressDnsAlt3 As String, ByVal sPBIPAddressDnsAlt4 As String, _
    ByVal sPBIPAddressWins1 As String, ByVal sPBIPAddressWins2 As String, _
    ByVal sPBIPAddressWins3 As String, ByVal sPBIPAddressWins4 As String, _
    ByVal sPBIPAddressWinsAlt1 As String, ByVal sPBIPAddressWinsAlt2 As String, _
    ByVal sPBIPAddressWinsAlt3 As String, ByVal sPBIPAddressWinsAlt4 As String, _
    ByVal bPBIpHeaderCompression As Boolean, ByVal bPBSwCompression As Boolean, _
    ByVal bPBSlip As Boolean, ByVal bPBGPRS As Boolean, ByVal sPBFlowControl As String, _
    ByVal sPBCredit As String, ByVal sPBExtraDial As String, ByVal bPBBefore As Boolean, _
    ByVal bPBAfter As Boolean, ByVal bPBManually As Boolean, ByVal bPBWait As Boolean) As Integer

        Dim sNumbers As String
        Dim sSettings As String
        Dim sPBIPAddress As String
        Dim sPBIPAddresses As String
        Dim sExtraInfo As String

        Dim iPBBefore As Integer = 0
        Dim iPBAfter As Integer = 0
        Dim iPBManually As Integer = 0
        Dim iPBWait As Integer = 0
        Dim iPBUseCountryAndAreaCodes As Integer = 0
        Dim iPBDialAsLocalCall As Integer = 0
        Dim iPBSpecificIpAddr As Integer = 0
        Dim iPBSpecificNameServers As Integer = 0
        Dim iPBIpHeaderCompression As Integer = 0
        Dim iPBSwCompression As Integer = 0
        Dim iPBSlip As Integer = 0
        Dim iPBGPRS As Integer = 0

        If (bPBBefore) Then iPBBefore = 1
        If (bPBAfter) Then iPBAfter = 1
        If (bPBManually) Then iPBManually = 1
        If (bPBWait) Then iPBWait = 1
        If (bPBUseCountryAndAreaCodes) Then iPBUseCountryAndAreaCodes = 1
        If (bPBDialAsLocalCall) Then iPBDialAsLocalCall = 1
        If (bPBSpecificIpAddr) Then iPBSpecificIpAddr = 1
        If (bPBSpecificNameServers) Then iPBSpecificNameServers = 1
        If (bPBIpHeaderCompression) Then iPBIpHeaderCompression = 1
        If (bPBSwCompression) Then iPBSwCompression = 1
        If (bPBSlip) Then iPBSlip = 1
        If (bPBGPRS) Then iPBGPRS = 1

        sNumbers = sPBCountryCode & "|" & sPBAreaCode & "|" & sPBLocalPhoneNumber & "|" & sPBDeviceName
        sExtraInfo = sPBFlowControl & "|" & sPBCredit & "|" & sPBExtraDial & "|" & sPBDestination
        sSettings = sPBSecBeforeHangup & "|" & sPBBaudRate & "|" & sPBByteSize & "|" & sPBParity & "|" & sPBStopBits
        sPBIPAddress = sPBIPAddress1 & "|" & sPBIPAddress2 & "|" & sPBIPAddress3 & "|" & sPBIPAddress4
        sPBIPAddresses = sPBIPAddressDns1 & "|" & sPBIPAddressDns2 & "|" & sPBIPAddressDns3 & "|" & sPBIPAddressDns4 _
                & "|" & sPBIPAddressDnsAlt1 & "|" & sPBIPAddressDnsAlt2 & "|" & sPBIPAddressDnsAlt3 & "|" & sPBIPAddressDnsAlt4 _
                & "|" & sPBIPAddressWins1 & "|" & sPBIPAddressWins2 & "|" & sPBIPAddressWins3 & "|" & sPBIPAddressWins4 _
                & "|" & sPBIPAddressWinsAlt1 & "|" & sPBIPAddressWinsAlt2 & "|" & sPBIPAddressWinsAlt3 & "|" & sPBIPAddressWinsAlt4

        PBSet = sPBSet(sPBEntryName, sNumbers, sExtraInfo, sSettings, _
                        iPBBefore, iPBAfter, iPBManually, iPBWait, _
                        iPBUseCountryAndAreaCodes, iPBDialAsLocalCall, _
                        iPBSpecificIpAddr, sPBIPAddress, _
                        iPBSpecificNameServers, sPBIPAddresses, _
                        iPBIpHeaderCompression, iPBSwCompression, _
                        iPBSlip, iPBGPRS, SapphireRASLicence)
        ' Set SapphireRASLicence with your Licence Number unless Demo DLL
    End Function

    Friend Function PBValidate(ByVal sPBEntry As String) As Integer
        PBValidate = sPBValidate(sPBEntry)
    End Function

    Friend Function PBDelete(ByVal sPBEntry As String) As Integer
        PBDelete = sPBDelete(sPBEntry, SapphireRASLicence)
    End Function

    Friend Function PBRename(ByVal sPBEntryOld As String, ByVal sPBEntryNew As String) As Integer
        PBRename = sPBRename(sPBEntryOld, sPBEntryNew, SapphireRASLicence)
    End Function

    Friend Function PBNames(ByRef iEntries As Integer) As String
        Dim sRASNames As String = Space(2048)
        sPBNames(iEntries, sRASNames)
        PBNames = StripString(sRASNames)
    End Function

    Friend Function PBDevices(ByRef iEntries As Integer) As String
        Dim sDevNames As String
        sDevNames = Space(2048)
        sPBDevices(iEntries, sDevNames)
        PBDevices = StripString(sDevNames)
    End Function

    Friend Function PBDestinations() As String
        Dim sDestNames As String
        sDestNames = Space(2048)
        sPBDestinations(sDestNames)
        PBDestinations = StripString(sDestNames)
    End Function

    Friend Sub RefreshNames()
        Dim sNames As String
        Dim iCount As Integer
        Dim iEntries As Integer

        ' Set up the list of available connections
        fSetDial.cboEntry.Items.Clear()
        fSetPB.cboEntry.Items.Clear()
        iEntries = 0
        sNames = PBNames(iEntries)
        Dim sEntries() As String = Split(sNames, "|", -1)
        For iCount = 0 To iEntries - 1
            fSetDial.cboEntry.Items.Add(New ListItem(sEntries(iCount), iCount))
            fSetPB.cboEntry.Items.Add(New ListItem(sEntries(iCount), iCount))
        Next iCount
        If iEntries = 0 Then
            fSetDial.cboEntry.Items.Add(New ListItem("No Connections", 0))
            fSetPB.cboEntry.Items.Add(New ListItem("No Connections", 0))
        Else
            fSetDial.cboEntry.SelectedIndex = 0
            fSetPB.cboEntry.SelectedIndex = 0
            SetPBValues(fSetDial.cboEntry.Text)
        End If
    End Sub

    Friend Sub RefreshDevices()
        Dim sNames As String
        Dim iCount As Integer
        Dim iEntries As Integer

        ' Set up the list of available connections
        fSetPB.cboDevice.Items.Clear()
        fSetPBGprs.cboDevice.Items.Clear()
        iEntries = 0
        sNames = PBDevices(iEntries)
        Dim sDevices() As String = Split(sNames, "|", -1)
        For iCount = 0 To iEntries - 1
            fSetPB.cboDevice.Items.Add(New ListItem(sDevices(iCount), iCount))
            fSetPBGprs.cboDevice.Items.Add(New ListItem(sDevices(iCount), iCount))
        Next iCount
        If iEntries > 0 Then
            fSetPB.cboDevice.SelectedIndex = 0
            fSetPBGprs.cboDevice.SelectedIndex = 0
        End If

        fSetPB.cboDestination.Items.Clear()
        fSetPBGprs.cboDestination.Items.Clear()
        sNames = PBDestinations()
        Dim sDestinations() As String = Split(sNames, "|", -1)
        For iCount = 0 To UBound(sDestinations) - 1
            fSetPB.cboDestination.Items.Add(New ListItem(sDestinations(iCount), iCount))
            fSetPBGprs.cboDestination.Items.Add(New ListItem(sDestinations(iCount), iCount))
        Next iCount
        If UBound(sDestinations) > 0 Then
            fSetPB.cboDestination.SelectedIndex = 0
            fSetPBGprs.cboDestination.SelectedIndex = 0
        End If

    End Sub

    Friend Sub SetPBValues(ByVal PBName As String)
        Dim sEntry As String

        fSetPB.txtName.Text = PBName
        sEntry = PBGet(PBName)

        Dim sDetails() As String = Split(sEntry, "|", -1)

        If UBound(sDetails) > 0 Then
            fSetPB.txtCountryCode.Text = sDetails(0)
            fSetPB.txtAreaCode.Text = sDetails(1)
            fSetPB.txtLocalPhoneNumber.Text = sDetails(2)
            fSetPB.cboDevice.Text = sDetails(3)
            fSetPB.cboDestination.Text = sDetails(4)
            fSetPBAdv1.cboBaud.Text = sDetails(5)
            fSetPBAdv1.cboBits.Text = sDetails(6)
            fSetPBAdv1.cboParity.Text = sDetails(7)
            fSetPBAdv1.cboStop.Text = sDetails(8)
            fSetPBAdv4.txtTimeout.Text = sDetails(9)
            If sDetails(10) = "1" Then
                fSetPBAdv1.optIntCall.Checked = True
            Else
                fSetPBAdv1.optIntCall.Checked = False
            End If
            If sDetails(11) = "1" Then
                fSetPBAdv2.optSpecific.Checked = True
            Else
                fSetPBAdv2.optServerAssigned.Checked = True
            End If
            fSetPBAdv2.txtIPAddress1.Text = sDetails(12)
            fSetPBAdv2.txtIPAddress2.Text = sDetails(13)
            fSetPBAdv2.txtIPAddress3.Text = sDetails(14)
            fSetPBAdv2.txtIPAddress4.Text = sDetails(15)
            If sDetails(16) = "1" Then
                fSetPBAdv3.optSpecific.Checked = True
            Else
                fSetPBAdv3.optServerAssigned.Checked = True
            End If
            fSetPBAdv3.txtDNSAddress1.Text = sDetails(17)
            fSetPBAdv3.txtDNSAddress2.Text = sDetails(18)
            fSetPBAdv3.txtDNSAddress3.Text = sDetails(19)
            fSetPBAdv3.txtDNSAddress4.Text = sDetails(20)
            fSetPBAdv3.txtAltDNSAddress1.Text = sDetails(21)
            fSetPBAdv3.txtAltDNSAddress2.Text = sDetails(22)
            fSetPBAdv3.txtAltDNSAddress3.Text = sDetails(23)
            fSetPBAdv3.txtAltDNSAddress4.Text = sDetails(24)
            fSetPBAdv3.txtWINSAddress1.Text = sDetails(25)
            fSetPBAdv3.txtWINSAddress2.Text = sDetails(26)
            fSetPBAdv3.txtWINSAddress3.Text = sDetails(27)
            fSetPBAdv3.txtWINSAddress4.Text = sDetails(28)
            fSetPBAdv3.txtAltWINSAddress1.Text = sDetails(29)
            fSetPBAdv3.txtAltWINSAddress2.Text = sDetails(30)
            fSetPBAdv3.txtAltWINSAddress3.Text = sDetails(31)
            fSetPBAdv3.txtAltWINSAddress4.Text = sDetails(32)
            If sDetails(33) = "1" Then
                fSetPBAdv1.optLocalCall.Checked = True
            Else
                fSetPBAdv1.optLocalCall.Checked = False
            End If
            If sDetails(34) = "1" Then
                fSetPBAdv2.chkIPHeader.Checked = True
            Else
                fSetPBAdv2.chkIPHeader.Checked = False
            End If
            If sDetails(35) = "1" Then
                fSetPBAdv2.chkSoftware.Checked = True
            Else
                fSetPBAdv2.chkSoftware.Checked = False
            End If
            If sDetails(36) = "1" Then
                fSetPBAdv2.chkSlip.Checked = True
            Else
                fSetPBAdv2.chkSlip.Checked = False
            End If
            fSetPBAdv1.cboFlowControl.Text = sDetails(37)
            fSetPBAdv4.txtCredit.Text = sDetails(38)
            fSetPBAdv4.txtExtraDial.Text = sDetails(39)
            If sDetails(40) = "1" Then
                fSetPBAdv4.chkBefore.Checked = True
            Else
                fSetPBAdv4.chkBefore.Checked = False
            End If
            If sDetails(41) = "1" Then
                fSetPBAdv4.chkAfter.Checked = True
            Else
                fSetPBAdv4.chkAfter.Checked = False
            End If
            If sDetails(42) = "1" Then
                fSetPBAdv4.chkManually.Checked = True
            Else
                fSetPBAdv4.chkManually.Checked = False
            End If
            If sDetails(43) = "1" Then
                fSetPBAdv4.chkWait.Checked = True
            Else
                fSetPBAdv4.chkWait.Checked = False
            End If
        End If
    End Sub

    Friend Sub IPServerAssigned()
        fSetPBAdv2.txtIPAddress1.Enabled = False
        fSetPBAdv2.txtIPAddress2.Enabled = False
        fSetPBAdv2.txtIPAddress3.Enabled = False
        fSetPBAdv2.txtIPAddress4.Enabled = False
    End Sub

    Friend Sub IPSpecific()
        fSetPBAdv2.txtIPAddress1.Enabled = True
        fSetPBAdv2.txtIPAddress2.Enabled = True
        fSetPBAdv2.txtIPAddress3.Enabled = True
        fSetPBAdv2.txtIPAddress4.Enabled = True
    End Sub

    Friend Sub NameServerAssigned()
        fSetPBAdv3.txtDNSAddress1.Enabled = False
        fSetPBAdv3.txtDNSAddress2.Enabled = False
        fSetPBAdv3.txtDNSAddress3.Enabled = False
        fSetPBAdv3.txtDNSAddress4.Enabled = False
        fSetPBAdv3.txtAltDNSAddress1.Enabled = False
        fSetPBAdv3.txtAltDNSAddress2.Enabled = False
        fSetPBAdv3.txtAltDNSAddress3.Enabled = False
        fSetPBAdv3.txtAltDNSAddress4.Enabled = False
        fSetPBAdv3.txtWINSAddress1.Enabled = False
        fSetPBAdv3.txtWINSAddress2.Enabled = False
        fSetPBAdv3.txtWINSAddress3.Enabled = False
        fSetPBAdv3.txtWINSAddress4.Enabled = False
        fSetPBAdv3.txtAltWINSAddress1.Enabled = False
        fSetPBAdv3.txtAltWINSAddress2.Enabled = False
        fSetPBAdv3.txtAltWINSAddress3.Enabled = False
        fSetPBAdv3.txtAltWINSAddress4.Enabled = False
    End Sub

    Friend Sub NameSpecific()
        fSetPBAdv3.txtDNSAddress1.Enabled = True
        fSetPBAdv3.txtDNSAddress2.Enabled = True
        fSetPBAdv3.txtDNSAddress3.Enabled = True
        fSetPBAdv3.txtDNSAddress4.Enabled = True
        fSetPBAdv3.txtAltDNSAddress1.Enabled = True
        fSetPBAdv3.txtAltDNSAddress2.Enabled = True
        fSetPBAdv3.txtAltDNSAddress3.Enabled = True
        fSetPBAdv3.txtAltDNSAddress4.Enabled = True
        fSetPBAdv3.txtWINSAddress1.Enabled = True
        fSetPBAdv3.txtWINSAddress2.Enabled = True
        fSetPBAdv3.txtWINSAddress3.Enabled = True
        fSetPBAdv3.txtWINSAddress4.Enabled = True
        fSetPBAdv3.txtAltWINSAddress1.Enabled = True
        fSetPBAdv3.txtAltWINSAddress2.Enabled = True
        fSetPBAdv3.txtAltWINSAddress3.Enabled = True
        fSetPBAdv3.txtAltWINSAddress4.Enabled = True
    End Sub

    Friend Function PBGetWorkInternet() As Integer
        PBGetWorkInternet = sPBGetWorkInternet()
    End Function

    Friend Function PBSetWorkInternet(ByVal iNumber As Integer) As Integer
        PBSetWorkInternet = sPBSetWorkInternet(iNumber)
    End Function

    Friend Function PBSetDefault(ByVal sPBEntry As String) As Integer
        PBSetDefault = sPBSetDefault(sPBEntry, SapphireRASLicence)
    End Function

    Friend Sub SetPBSettings()
        Dim sEntry As String

        sUserPass = False
        sConnectionEntry = fSetDial.cboEntry.Text
        sEntry = RASGetParams(sConnectionEntry)
        Dim sEntries() As String = Split(sEntry, "|", -1)
        If UBound(sEntries) > 0 Then
            sUsername = sEntries(0)
            fSetDial.txtUsername.Text = sUsername
            sPassword = sEntries(1)
            fSetDial.txtPassword.Text = sPassword
            sDomain = sEntries(2)
            fSetDial.txtDomain.Text = sDomain
        End If
    End Sub
End Module
