Attribute VB_Name = "modFTP"
Option Explicit

' Error codes
Public Const FTP_NO_ERROR = 0
Public Const FTP_TOO_MANY_INTERNET_HANDLES = 1
Public Const FTP_TIMEOUT = 2
Public Const FTP_INTERNAL_ERROR = 3
Public Const FTP_INVALID_URL = 4
Public Const FTP_NAME_NOT_RESOLVED = 5
Public Const FTP_PROTOCOL_NOT_FOUND = 6
Public Const FTP_SHUTDOWN = 7
Public Const FTP_INCORRECT_USER_NAME = 8
Public Const FTP_INCORRECT_PASSWORD = 9
Public Const FTP_LOGIN_FAILED = 10
Public Const FTP_REQUEST_PENDING = 11
Public Const FTP_CANNOT_CONNECT = 12
Public Const FTP_CONNECTION_ABORTED = 13
Public Const FTP_CONNECTION_RESET = 14
Public Const FTP_FORCE_RETRY = 15
Public Const FTP_INVALID_PROXY_REQUEST = 16
Public Const FTP_TRANSFER_IN_PROGRESS = 17
Public Const FTP_DROPPED = 18
Public Const FTP_NO_PASSIVE_MODE = 19
Public Const FTP_LOCAL_FILE_EXISTS = 20
Public Const FTP_UNKNOWN = 21

' Overwrite modes
Public Const FTP_OVERWRITE = 1
Public Const FTP_DONT_OVERWRITE = 0

' Transfer modes
Public Const FTP_TRANSFER_UNKNOWN = 0
Public Const FTP_TRANSFER_ASCII = 1
Public Const FTP_TRANSFER_BINARY = 2

Public Const DEFAULT_FTP_PORT = 21

' Timeout in miliseconds
Private Const FTP_TIMEOUT_SETTING = 10000

' FTP Settings
Public sFTPSession As String
Public sFTPUsername As String
Public sFTPPassword As String
Public sLocalFilter As String
Public sRemoteFilter As String
Public sFTPLocalPath As String
Public sFTPRemotePath As String

Public sSessions(3) As String
Public sUsernames(3) As String
Public sPasswords(3) As String
Public lPassive As Long

Declare Function sFTPOpen Lib "SapphireFTP.dll" (ByVal sServer As String, ByVal lPort As Long, ByVal sUser As String, ByVal sPwd As String, ByVal lPassive As Long, ByVal lTimeOut As Long, ByVal lLicence As Long) As Long
Declare Function sFTPGet Lib "SapphireFTP.dll" (ByVal sRemoteFile As String, ByVal sLocalFile As String, ByVal bOverWriteFile As Long, ByVal lTransferType As Long, ByVal lLicence As Long) As Long
Declare Function sFTPPull Lib "SapphireFTP.dll" (ByVal sRemoteFile As String, ByVal sLocalFile As String, ByVal bOverWriteFile As Long, ByVal lTransferType As Long, ByVal lLicence As Long) As Long
Declare Function sFTPPullStart Lib "SapphireFTP.dll" (ByVal sRemoteFile As String, ByVal sLocalFile As String, ByVal bOverWriteFile As Long, ByVal lTransferType As Long, ByVal lLicence As Long) As Long
Declare Function sFTPPullMore Lib "SapphireFTP.dll" () As Long
Declare Function sFTPPullEnd Lib "SapphireFTP.dll" () As Long
Declare Function sFTPPut Lib "SapphireFTP.dll" (ByVal sLocalFile As String, ByVal sRemoteFile As String, ByVal lTransferType As Long, ByVal lLicence As Long) As Long
Declare Function sFTPPush Lib "SapphireFTP.dll" (ByVal sLocalFile As String, ByVal sRemoteFile As String, ByVal lTransferType As Long, ByVal lLicence As Long) As Long
Declare Function sFTPPushStart Lib "SapphireFTP.dll" (ByVal sLocalFile As String, ByVal sRemoteFile As String, ByVal lTransferType As Long, ByVal lLicence As Long) As Long
Declare Function sFTPPushMore Lib "SapphireFTP.dll" () As Long
Declare Function sFTPPushEnd Lib "SapphireFTP.dll" () As Long
Declare Function sFTPClose Lib "SapphireFTP.dll" (ByVal lLicense As Long) As Long

Declare Function sFTPChangeDirectory Lib "SapphireFTP.dll" (ByVal sPath As String, ByVal lLicence As Long) As Long
Declare Function sFTPCurrentDirectory Lib "SapphireFTP.dll" (ByVal sCurrentDirectory As String, ByVal lLicence As Long) As Long
Declare Function sFTPFileExists Lib "SapphireFTP.dll" (ByVal sFile As String, ByVal lLicence As Long) As Long
Declare Function sFTPFindFirstFile Lib "SapphireFTP.dll" (ByVal sFileString As String, ByVal sFilter As String, ByVal lLicence As Long) As Long
Declare Function sFTPFindNextFile Lib "SapphireFTP.dll" (ByVal sFileString As String, ByVal lLicence As Long) As Long
Declare Function sFTPRemoveFile Lib "SapphireFTP.dll" (ByVal sRemoteFile As String, ByVal lLicence As Long) As Long
Declare Function sFTPRenameFile Lib "SapphireFTP.dll" (ByVal sOldFile As String, ByVal sNewFile As String, ByVal lLicence As Long) As Long
Declare Function sFTPRemoveDirectory Lib "SapphireFTP.dll" (ByVal sDirectory As String, ByVal lLicence As Long) As Long
Declare Function sFTPMakeDirectory Lib "SapphireFTP.dll" (ByVal sDirectory As String, ByVal lLicence As Long) As Long

Declare Function sFTPUploadDirectory Lib "SapphireFTP.dll" (ByVal sLocalDirectory As String, ByVal lLicence As Long) As Long
Declare Function sFTPDownloadDirectory Lib "SapphireFTP.dll" (ByVal sRemoteDirectory As String, ByVal sLocalPath As String, ByVal lLicence As Long) As Long

Declare Sub sFTPErrorText Lib "SapphireFTP.dll" (ByVal sErrorText As String, ByVal lError As Long)
Declare Function sFTPReconnect Lib "SapphireFTP.dll" (ByVal lPassive As Long, ByVal lLicence As Long) As Long

Public Function FTPErrorText(lVal As Long) As String
    Dim sError As String
    
    sError = Space(1024)
    sFTPErrorText sError, lVal
    FTPErrorText = StripString(sError)
End Function

Public Function FTPCurrentDirectory() As String
    Dim sReturn As String
    
    sReturn = Space(260)
    
    If sFTPCurrentDirectory(sReturn, SapphireFTPLicence) = 0 Then
        sReturn = "/"
    End If
    FTPCurrentDirectory = StripString(sReturn)
End Function

Public Function FTPFindFirstFile(sRemoteFilter As String) As String
    Dim sFile As String
    
    sFile = Space(1024)
    If sFTPFindFirstFile(sFile, sRemoteFilter, SapphireFTPLicence) = 0 Then
        sFile = ""
    End If
    FTPFindFirstFile = StripString(sFile)
End Function

Public Function FTPFindNextFile() As String
    Dim sFile As String
    
    sFile = Space(1024)
    If sFTPFindNextFile(sFile, SapphireFTPLicence) = 0 Then
        sFile = ""
    End If
    FTPFindNextFile = StripString(sFile)
End Function

Public Sub SetFTPSettings()
    frmSetFTP.cboSession.Clear
    
    ' Set up the default settings for FTP Web site
    sSessions(1) = "ftp.sapphire-solutions.co.uk"
    sUsernames(1) = "ftp.sapphireftp"
    sPasswords(1) = "sapphire123"
    frmSetFTP.cboSession.AddItem sSessions(1), 0
    
    sSessions(2) = "pentium4"
    sUsernames(2) = "anonymous"
    sPasswords(2) = "sales@sapphire-solutions.co.uk"
    frmSetFTP.cboSession.AddItem sSessions(2), 1
    
    frmSetFTP.cboSession.Text = sSessions(1)
    frmSetFTP.txtUsername.Text = sUsernames(1)
    frmSetFTP.txtPassword.Text = sPasswords(1)
    
    sFTPSession = sSessions(1)
    sFTPUsername = sUsernames(1)
    sFTPPassword = sPasswords(1)
    sFTPLocalPath = "\My Documents\"
    sFTPRemotePath = "/FTPSync/"
    lPassive = 1
End Sub

