Attribute VB_Name = "modFileManager"
Option Explicit

Public sLocalPath As String

Public Function InitialiseFileManager()
    sLocalPath = "\"
End Function

Public Function sLocalChangeDirectory(sDirectory As String) As Long
    Dim sDir As String
    Dim lCounter As Long
    
    sLocalChangeDirectory = 1

    If sDirectory = ".." Then
        If sLocalPath <> "\" Then
            ' Remove the last folder in the string
            sDir = Mid(sLocalPath, 1, Len(sLocalPath) - 1)
            lCounter = Len(sDir)
            While Mid(sDir, lCounter, 1) <> "\" And lCounter > 0
                sDir = Mid(sDir, 1, lCounter - 1)
                lCounter = lCounter - 1
            Wend
            
            If fsControl.GetAttr(sDir) And vbDirectory = vbDirectory Then
                 sLocalPath = sDir
                 sLocalChangeDirectory = 0
             End If
        End If
    Else
        If fsControl.GetAttr(sLocalPath & sDirectory) And vbDirectory = vbDirectory Then
            sLocalPath = sLocalPath & sDirectory & "\"
            sLocalChangeDirectory = 0
        End If
    End If
End Function

Public Function sLocalCurrentDirectory() As String
    sLocalCurrentDirectory = sLocalPath
End Function

Public Sub sLocalRefreshList()
    Dim liFile As ListItem
    Dim sFilename As String
    Dim lSize As Long
    
    frmFTPExplorer.lstLocal.ListItems.Clear
    
    frmFTPExplorer.lblLocal.Caption = "Local Directory: " & sLocalPath & sLocalFilter
    
    If sLocalPath <> "\" Then
        Set liFile = frmFTPExplorer.lstLocal.ListItems.Add(, , "[..]")
        liFile.SubItems(1) = ""
        liFile.SubItems(2) = ""
        liFile.SubItems(3) = "DIR"
    End If
    
    sFilename = fsControl.Dir(sLocalPath & sLocalFilter)
    While sFilename <> ""
        ' See if the file is a directory
        If (fsControl.GetAttr(sLocalPath & sFilename) And vbDirectory) = vbDirectory Then
            Set liFile = frmFTPExplorer.lstLocal.ListItems.Add(, , "[" & sFilename & "]")
        Else
            Set liFile = frmFTPExplorer.lstLocal.ListItems.Add(, , sFilename)
        End If
        
        ' Get the file size for the file
        liFile.SubItems(1) = GetFileSizeText(fsControl.FileLen(sLocalPath & sFilename))
        
        ' Get the date of the file
        liFile.SubItems(2) = FormatDateTime(fsControl.FileDateTime(sLocalPath & sFilename), vbGeneralDate)
        
        ' Get the attributes of the file
        liFile.SubItems(3) = GetFileAttributes(sLocalPath & sFilename)
        
        sFilename = fsControl.Dir()
    Wend
    
    frmFTPExplorer.lstLocal.Sorted = True
End Sub

Public Function sLocalRemoveFile(sLocalFile As String) As Long
    On Error Resume Next
    
    Err.Clear
    fsControl.Kill (sLocalPath & sLocalFile)
    If Err.Number <> 0 Then
        sLocalRemoveFile = 1
    Else
        sLocalRemoveFile = 0
    End If
    
    On Error GoTo 0
End Function

Public Function sLocalRenameFile(sOldFile As String, sNewFile As String) As Long
    On Error Resume Next
    
    Err.Clear
    fsControl.MoveFile sLocalPath & sOldFile, sLocalPath & sNewFile
    If Err.Number <> 0 Then
        sLocalRenameFile = 1
    Else
        sLocalRenameFile = 0
    End If
    
    On Error GoTo 0
End Function

Public Function sLocalRemoveDirectory(sDirectory As String) As Long
    Dim sFilename As String
    Dim sDirs() As String
    Dim lDirs As Long
    Dim lDirCount As Long
    Dim lResult As Long
    
    On Error Resume Next
    
    lDirs = 0
  
    sFilename = fsControl.Dir(sLocalPath & sDirectory & "\*.*")
    While sFilename <> ""
        ' See if the file is a directory
        If (fsControl.GetAttr(sLocalPath & sDirectory & "\" & sFilename) And vbDirectory) = vbDirectory Then
            lDirs = lDirs + 1
            ReDim Preserve sDirs(lDirs)
            sDirs(lDirs) = sFilename
        Else
            ' Delete the file
            Err.Clear
            fsControl.Kill sLocalPath & sDirectory & "\" & sFilename
            If Err.Number <> 0 Then
                sLocalRemoveDirectory = Err.Number
                Exit Function
            End If
        End If
        sFilename = fsControl.Dir()
    Wend
    
    ' Now remove everything in the sub directories
    For lDirCount = 1 To lDirs
        lResult = sLocalRemoveDirectory(sDirectory & "\" & sDirs(lDirCount))
        If lResult <> 0 Then
            sLocalRemoveDirectory = lResult
            Exit Function
        End If
    Next lDirCount
    
    ' Now remove the directory
    Err.Clear
    fsControl.RmDir (sLocalPath & sDirectory)
    If Err.Number <> 0 Then
        sLocalRemoveDirectory = Err.Number
    Else
        sLocalRemoveDirectory = 0
    End If
   
    On Error GoTo 0
End Function

Public Function sLocalMakeDirectory(sDirectory As String) As Long
    On Error Resume Next
    
    Err.Clear
    fsControl.MkDir sLocalPath & sDirectory
    If Err.Number <> 0 Then
        sLocalMakeDirectory = 1
    Else
        sLocalMakeDirectory = 0
    End If
    On Error GoTo 0
End Function

Public Function GetFileSizeText(lSize As Long) As String
    If lSize < 1024 Then
        If lSize = 1 Then
            GetFileSizeText = "1 byte"
        Else
            GetFileSizeText = lSize & " bytes"
        End If
    ElseIf lSize < 1024 * 1024 Then
        GetFileSizeText = CLng(lSize / 1024) & " KB"
    Else
        GetFileSizeText = CLng(lSize / (1024 * 1024)) & " MB"
    End If
End Function

Private Function GetFileAttributes(sFile As String) As String
    Dim sAttributes As String
    Dim bComma As Boolean
    Dim lAttributes As Long
    
    bComma = False
    sAttributes = ""
    
    lAttributes = fsControl.GetAttr(sFile)
    
    If (lAttributes And vbReadOnly) = vbReadOnly Then
        If bComma Then
            sAttributes = ",RD"
        Else
            sAttributes = "RD"
        End If
        bComma = True
    End If
    If (lAttributes And vbHidden) = vbHidden Then
        If bComma Then
            sAttributes = ",HID"
        Else
            sAttributes = "HID"
        End If
        bComma = True
    End If
    If (lAttributes And vbSystem) = vbSystem Then
        If bComma Then
            sAttributes = ",SYS"
        Else
            sAttributes = "SYS"
        End If
        bComma = True
    End If
    If (lAttributes And vbDirectory) = vbDirectory Then
        If bComma Then
            sAttributes = ",DIR"
        Else
            sAttributes = "DIR"
        End If
        bComma = True
    End If
    If (lAttributes And vbArchive) = vbArchive Then
        If bComma Then
            sAttributes = ",ARC"
        Else
            sAttributes = "ARC"
        End If
        bComma = True
    End If
    
    GetFileAttributes = sAttributes
    
End Function

Public Function sLocalFileExists(sLocalFile As String) As Boolean
    If fsControl.Dir(sLocalFile) = "" Then
        sLocalFileExists = False
    Else
        sLocalFileExists = True
    End If
End Function
