Attribute VB_Name = "modLocation"
Option Explicit

Declare Function sLOCGetCurrent Lib "SapphireRAS.dll" () As Long
Declare Function sLOCSetCurrent Lib "SapphireRAS.dll" (ByVal lNumber As Long) As Long
Declare Function sLOCGetNumber Lib "SapphireRAS.dll" () As Long
Declare Function sLOCSetNumber Lib "SapphireRAS.dll" (ByVal lNumber As Long) As Long
Declare Function sLOCGetLocation Lib "SapphireRAS.dll" (ByVal lNumber As Long, ByVal sLocations As String) As Long
Declare Function sLOCSetLocation Lib "SapphireRAS.dll" (ByVal lNumber As Long, ByVal sSettings As String) As Long
Declare Function sLOCDeleteLocation Lib "SapphireRAS.dll" (ByVal lNumber As Long) As Long

Public Function LOCGetCurrent() As Long
    LOCGetCurrent = sLOCGetCurrent()
End Function

Public Function LOCSetCurrent(lNumber As Long) As Long
    LOCSetCurrent = sLOCSetCurrent(lNumber)
End Function

Public Function LOCGetNumber() As Long
    LOCGetNumber = sLOCGetNumber()
End Function

Public Function LOCSetNumber(lNumber As Long) As Long
    LOCSetNumber = sLOCSetNumber(lNumber)
End Function

Public Function LOCGetLocation(lNumber As Long) As String
    Dim sLocations As String
    
    sLocations = Space(1024)
    sLOCGetLocation lNumber, sLocations
    LOCGetLocation = StripString(sLocations)
End Function

Public Function LOCSetLocation(lNumber As Long, sName As String, sLocal As String, _
        sLong As String, sInternational As String, sArea As String, sCountry As String) As Long
    Dim sSettings As String
    Dim sCallWaiting As String
    Dim sTone As String
    
    sCallWaiting = "" ' Call Waiting disable string
    sTone = "0" ' 0 = Tone Dialling ; 1 = Pulse Dialling
    sSettings = sName & "|" & sLocal & "|" & sLong & "|" & sInternational & "|" & sArea & "|" & sCallWaiting & "|" & sCountry & "|" & sTone & "|"
    LOCSetLocation = sLOCSetLocation(lNumber, sSettings)
End Function

Public Function LOCDeleteLocation(lNumber As Long) As Long
    LOCDeleteLocation = sLOCDeleteLocation(lNumber)
End Function

Public Sub RefreshLocations()
    Dim sEntry As String
    Dim lNumber As Long
    Dim lCount As Long
    Dim lIndex As Long
    Dim iPos As Integer
    
    lNumber = LOCGetNumber
    frmSetLocation.cboName.Clear
    lIndex = 0
    For lCount = 1 To lNumber
        sEntry = LOCGetLocation(lCount - 1)
        If sEntry <> "" Then
            iPos = InStr(1, sEntry, "|")
            frmSetLocation.cboName.AddItem Mid(sEntry, 1, iPos - 1), lIndex
            frmSetLocation.cboName.ItemData(frmSetLocation.cboName.NewIndex) = lCount - 1
            lIndex = lIndex + 1
        End If
    Next lCount
End Sub

Public Sub SetLOCValues(lNumber As Long)
    Dim sEntry As String
    Dim iPos As Integer
    Dim iStart As Integer
    Dim lCount As Long
    
    sEntry = LOCGetLocation(lNumber)
    iStart = 1
    iPos = InStr(iStart, sEntry, "|")
    If iPos <> 0 Then
        For lCount = 1 To frmSetLocation.cboName.ListCount
            If frmSetLocation.cboName.ItemData(lCount - 1) = lNumber Then
                frmSetLocation.cboName.ListIndex = lCount - 1
                Exit For
            End If
        Next lCount
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetLocation.txtLocal.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetLocation.txtLong.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetLocation.txtInternational.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetLocation.txtArea.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        ' Disable Call Waiting disable string
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetLocation.txtCountry.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        ' 0 for Tone Dialing ; 1 for Pulse Dialing
    End If
End Sub


