Attribute VB_Name = "modPB"
Option Explicit

Declare Function sPBGet Lib "SapphireRAS.dll" (ByVal sEntryName As String, ByVal sPDData As String, ByVal lLicence As Long) As Long
Declare Function sPBSet Lib "SapphireRAS.dll" (ByVal sEntryName As String, _
        ByVal sNumbers As String, ByVal sExtraInfo As String, ByVal sSettings As String, _
        ByVal lPBBefore As Long, ByVal lPBAfter As Long, _
        ByVal lPBManually As Long, ByVal lPBWait As Long, _
        ByVal lUseCountryAndAreaCodes As Long, ByVal lDialAsLocalCall As Long, _
        ByVal lSpecificIpAddr As Long, ByVal sIPAddress As String, _
        ByVal lSpecificNameServers As Long, ByVal sIPAddresses As String, _
        ByVal lIpHeaderCompression As Long, ByVal lSwCompression As Long, _
        ByVal lSlip As Long, ByVal lGPRS As Long, ByVal lLicence As Long) As Long
Declare Function sPBValidate Lib "SapphireRAS.dll" (ByVal sEntryName As String) As Long
Declare Function sPBDelete Lib "SapphireRAS.dll" (ByVal sEntryName As String, ByVal lLicence As Long) As Long
Declare Function sPBRename Lib "SapphireRAS.dll" (ByVal sOldEntryName As String, ByVal sNewEntryName As String, ByVal lLicence As Long) As Long
Declare Function sPBNames Lib "SapphireRAS.dll" (ByRef lEntries As Long, ByVal sRASNames As String) As Long
Declare Function sPBDevices Lib "SapphireRAS.dll" (ByRef lEntries As Long, ByVal sRASNames As String) As Long
Declare Function sPBGetWorkInternet Lib "SapphireRAS.dll" () As Long
Declare Function sPBSetWorkInternet Lib "SapphireRAS.dll" (ByVal lNumber As Long) As Long
Declare Function sPBSetDefault Lib "SapphireRAS.dll" (ByVal sEntryName As String, ByVal lLicence As Long) As Long
Declare Function sPBDestinations Lib "SapphireRAS.dll" (ByVal sDestNames As String) As Long


Public Function PBGet(sPBEntry As String) As String
    Dim sPBData As String
    sPBData = Space(1024)
    sPBGet sPBEntry, sPBData, SapphireRASLicence
    PBGet = StripString(sPBData)
    ' Set Licence with your Licence Number unless Demo DLL
End Function

    Public Function PBSet(ByVal sPBEntryName As String, ByVal sPBCountryCode As String, ByVal sPBAreaCode As String, _
        ByVal sPBLocalPhoneNumber As String, ByVal sPBDeviceName As String, ByVal sPBDestination As String, _
        ByVal sPBBaudRate As String, ByVal sPBByteSize As String, ByVal sPBParity As String, _
        ByVal sPBStopBits As String, ByVal sPBSecBeforeHangup As String, _
        ByVal bPBUseCountryAndAreaCodes As Boolean, ByVal bPBDialAsLocalCall As Boolean, _
        ByVal bPBSpecificIpAddr As Boolean, ByVal sPBIPAddress1 As String, _
        ByVal sPBIPAddress2 As String, ByVal sPBIPAddress3 As String, _
        ByVal sPBIPAddress4 As String, ByVal bPBSpecificNameServers As Boolean, _
        ByVal sPBIPAddressDns1 As String, ByVal sPBIPAddressDns2 As String, _
        ByVal sPBIPAddressDns3 As String, ByVal sPBIPAddressDns4 As String, _
        ByVal sPBIPAddressDnsAlt1 As String, ByVal sPBIPAddressDnsAlt2 As String, _
        ByVal sPBIPAddressDnsAlt3 As String, ByVal sPBIPAddressDnsAlt4 As String, _
        ByVal sPBIPAddressWins1 As String, ByVal sPBIPAddressWins2 As String, _
        ByVal sPBIPAddressWins3 As String, ByVal sPBIPAddressWins4 As String, _
        ByVal sPBIPAddressWinsAlt1 As String, ByVal sPBIPAddressWinsAlt2 As String, _
        ByVal sPBIPAddressWinsAlt3 As String, ByVal sPBIPAddressWinsAlt4 As String, _
        ByVal bPBIpHeaderCompression As Boolean, ByVal bPBSwCompression As Boolean, _
        ByVal bPBSlip As Boolean, ByVal bPBGPRS As Boolean, ByVal sPBFlowControl As String, _
        ByVal sPBCredit As String, ByVal sPBExtraDial As String, ByVal bPBBefore As Boolean, _
        ByVal bPBAfter As Boolean, ByVal bPBManually As Boolean, ByVal bPBWait As Boolean) As Integer

        Dim sNumbers As String
        Dim sSettings As String
        Dim sPBIPAddress As String
        Dim sPBIPAddresses As String
        Dim sExtraInfo As String

        Dim lPBBefore As Integer
        Dim lPBAfter As Integer
        Dim lPBManually As Integer
        Dim lPBWait As Integer
        Dim lPBUseCountryAndAreaCodes As Integer
        Dim lPBDialAsLocalCall As Integer
        Dim lPBSpecificIpAddr As Integer
        Dim lPBSpecificNameServers As Integer
        Dim lPBIpHeaderCompression As Integer
        Dim lPBSwCompression As Integer
        Dim lPBSlip As Integer
        Dim lPBGPRS As Integer

        lPBBefore = 0
        lPBAfter = 0
        lPBManually = 0
        lPBWait = 0
        lPBUseCountryAndAreaCodes = 0
        lPBDialAsLocalCall = 0
        lPBSpecificIpAddr = 0
        lPBSpecificNameServers = 0
        lPBIpHeaderCompression = 0
        lPBSwCompression = 0
        lPBSlip = 0
        lPBGPRS = 0

        If (bPBBefore) Then lPBBefore = 1
        If (bPBAfter) Then lPBAfter = 1
        If (bPBManually) Then lPBManually = 1
        If (bPBWait) Then lPBWait = 1
        If (bPBUseCountryAndAreaCodes) Then lPBUseCountryAndAreaCodes = 1
        If (bPBDialAsLocalCall) Then lPBDialAsLocalCall = 1
        If (bPBSpecificIpAddr) Then lPBSpecificIpAddr = 1
        If (bPBSpecificNameServers) Then lPBSpecificNameServers = 1
        If (bPBIpHeaderCompression) Then lPBIpHeaderCompression = 1
        If (bPBSwCompression) Then lPBSwCompression = 1
        If (bPBSlip) Then lPBSlip = 1
        If (bPBGPRS) Then lPBGPRS = 1

        sNumbers = sPBCountryCode & "|" & sPBAreaCode & "|" & sPBLocalPhoneNumber & "|" & sPBDeviceName
        sExtraInfo = sPBFlowControl & "|" & sPBCredit & "|" & sPBExtraDial & "|" & sPBDestination
        sSettings = sPBSecBeforeHangup & "|" & sPBBaudRate & "|" & sPBByteSize & "|" & sPBParity & "|" & sPBStopBits
        sPBIPAddress = sPBIPAddress1 & "|" & sPBIPAddress2 & "|" & sPBIPAddress3 & "|" & sPBIPAddress4
        sPBIPAddresses = sPBIPAddressDns1 & "|" & sPBIPAddressDns2 & "|" & sPBIPAddressDns3 & "|" & sPBIPAddressDns4 _
                & "|" & sPBIPAddressDnsAlt1 & "|" & sPBIPAddressDnsAlt2 & "|" & sPBIPAddressDnsAlt3 & "|" & sPBIPAddressDnsAlt4 _
                & "|" & sPBIPAddressWins1 & "|" & sPBIPAddressWins2 & "|" & sPBIPAddressWins3 & "|" & sPBIPAddressWins4 _
                & "|" & sPBIPAddressWinsAlt1 & "|" & sPBIPAddressWinsAlt2 & "|" & sPBIPAddressWinsAlt3 & "|" & sPBIPAddressWinsAlt4

        PBSet = sPBSet(sPBEntryName, sNumbers, sExtraInfo, sSettings, _
                        lPBBefore, lPBAfter, lPBManually, lPBWait, _
                        lPBUseCountryAndAreaCodes, lPBDialAsLocalCall, _
                        lPBSpecificIpAddr, sPBIPAddress, _
                        lPBSpecificNameServers, sPBIPAddresses, _
                        lPBIpHeaderCompression, lPBSwCompression, _
                        lPBSlip, lPBGPRS, SapphireRASLicence)
        ' Set SapphireRASLicence with your Licence Number unless Demo DLL
End Function

Public Function PBValidate(sPBEntry As String) As Long
    PBValidate = sPBValidate(sPBEntry)
End Function

Public Function PBDelete(sPBEntry As String) As Long
    PBDelete = sPBDelete(sPBEntry, SapphireRASLicence)
End Function

Public Function PBRename(sPBEntryOld As String, sPBEntryNew As String) As Long
    PBRename = sPBRename(sPBEntryOld, sPBEntryNew, SapphireRASLicence)
End Function

Public Function PBGetWorkInternet() As Long
    PBGetWorkInternet = sPBGetWorkInternet()
End Function

Public Function PBSetWorkInternet(lNumber As Long) As Long
    PBSetWorkInternet = sPBSetWorkInternet(lNumber)
End Function

Public Function PBSetDefault(sPBEntry As String) As Long
    PBSetDefault = sPBSetDefault(sPBEntry, SapphireRASLicence)
End Function

Public Function PBNames(lEntries As Long) As String
    Dim sRASNames As String
    
    sRASNames = Space(1024)
    sPBNames lEntries, sRASNames
    PBNames = StripString(sRASNames)
End Function

Public Function PBDevices(lEntries As Long) As String
    Dim sDevices As String
    
    sDevices = Space(1024)
    sPBDevices lEntries, sDevices
    PBDevices = StripString(sDevices)
End Function
    
Public Function PBDestinations() As String
    Dim sDestNames As String
    
    sDestNames = Space(1024)
    sPBDestinations sDestNames
    PBDestinations = StripString(sDestNames)
End Function

Public Sub RefreshNames()
    Dim sNames As String
    Dim lCount As Long
    Dim iPos As Integer
    Dim iStart As Integer
    Dim lEntries As Long
    
    ' Set up the list of available connections
    frmSetDial.cboEntry.Clear
    frmSetPB.cboEntry.Clear
    lEntries = 0
    sNames = PBNames(lEntries)
    iStart = 1
    For lCount = 1 To lEntries
        iPos = InStr(iStart, sNames, "|")
        If iPos <> 0 Then
            sEntries(lCount) = Mid(sNames, iStart, iPos - iStart)
            frmSetDial.cboEntry.AddItem sEntries(lCount), lCount - 1
            frmSetPB.cboEntry.AddItem sEntries(lCount), lCount - 1
            iStart = iPos + 1
        End If
    Next lCount
    If lEntries = 0 Then
        sEntries(1) = "No Connections"
        frmSetDial.cboEntry.AddItem sEntries(1), 0
        frmSetPB.cboEntry.AddItem sEntries(1), 0
    Else
        frmSetPB.cboEntry.Text = sEntries(1)
        frmSetPB.cboEntry.ListIndex = 0
        SetPBValues (sEntries(1))
    End If
End Sub

Public Sub RefreshDevices()
    Dim sNames As String
    Dim lCount As Long
    Dim iPos As Integer
    Dim iStart As Integer
    Dim lEntries As Long
    
    ' Set up the list of available connections
    frmSetPB.cboDevice.Clear
    frmSetPBGprs.cboDevice.Clear
    lEntries = 0
    sNames = PBDevices(lEntries)
    iStart = 1
    For lCount = 1 To lEntries
        iPos = InStr(iStart, sNames, "|")
        If iPos <> 0 Then
            sDevices(lCount) = Mid(sNames, iStart, iPos - iStart)
            frmSetPB.cboDevice.AddItem sDevices(lCount), lCount - 1
            frmSetPBGprs.cboDevice.AddItem sDevices(lCount), lCount - 1
            iStart = iPos + 1
        End If
    Next lCount
    
    frmSetPB.cboDestination.Clear
    frmSetPBGprs.cboDestination.Clear
    sNames = PBDestinations
    iStart = 1
    lCount = 1
    iPos = InStr(iStart, sNames, "|")
    While (iPos > 0)
        frmSetPB.cboDestination.AddItem Mid(sNames, iStart, iPos - iStart), lCount - 1
        frmSetPBGprs.cboDestination.AddItem Mid(sNames, iStart, iPos - iStart), lCount - 1
        iStart = iPos + 1
        iPos = InStr(iStart, sNames, "|")
        lCount = lCount + 1
    Wend
End Sub

Public Function SetPBSettings()
    Dim sEntry As String
    Dim iPos As Integer
    Dim iStart As Integer

    sUserPass = False
    sConnectionEntry = sEntries(1)
    frmSetDial.cboEntry.Text = sConnectionEntry
    sEntry = RASGetParams(sConnectionEntry)
    iStart = 1
    iPos = InStr(iStart, sEntry, "|")
    If iPos <> 0 Then
        sUsername = Mid(sEntry, iStart, iPos - iStart)
        frmSetDial.txtUsername.Text = sUsername
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        sPassword = Mid(sEntry, iStart, iPos - iStart)
        frmSetDial.txtPassword.Text = sPassword
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        sDomain = Mid(sEntry, iStart, iPos - iStart)
        frmSetDial.txtDomain.Text = sDomain
    End If
End Function

Public Sub SetPBValues(PBName As String)
    Dim sEntry As String
    Dim iPos As Integer
    Dim iStart As Integer

    sEntry = PBGet(PBName)

    iStart = 1
    iPos = InStr(iStart, sEntry, "|")
    If iPos <> 0 Then
        frmSetPB.txtCountryCode.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPB.txtAreaCode.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPB.txtLocalPhoneNumber.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPB.cboDevice.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPB.cboDestination.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv1.cboBaud.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv1.cboBits.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv1.cboParity.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv1.cboStop.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv4.txtTimeout.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        If Mid(sEntry, iStart, iPos - iStart) = "1" Then
            frmSetPBAdv1.optIntCall.Value = True
        Else
            frmSetPBAdv1.optIntCall.Value = False
        End If
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        If Mid(sEntry, iStart, iPos - iStart) = "1" Then
            IPSpecific
        Else
            IPServerAssigned
        End If
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv2.txtIPAddress1.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv2.txtIPAddress2.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv2.txtIPAddress3.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv2.txtIPAddress4.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        If Mid(sEntry, iStart, iPos - iStart) = "1" Then
            NameSpecific
        Else
            NameServerAssigned
        End If
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtDNSAddress1.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtDNSAddress2.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtDNSAddress3.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtDNSAddress4.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltDNSAddress1.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltDNSAddress2.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltDNSAddress3.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltDNSAddress4.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtWINSAddress1.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtWINSAddress2.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtWINSAddress3.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtWINSAddress4.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltWINSAddress1.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltWINSAddress2.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltWINSAddress3.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv3.txtAltWINSAddress4.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        If Mid(sEntry, iStart, iPos - iStart) = "1" Then
            frmSetPBAdv1.optLocalCall.Value = True
        Else
            frmSetPBAdv1.optLocalCall.Value = False
        End If
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv2.chkIPHeader.Value = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv2.chkSoftware.Value = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv2.chkSlip.Value = Mid(sEntry, iStart, iPos - iStart)
    
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv1.cboFlowControl.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv4.txtCredit.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv4.txtExtraDial.Text = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv4.chkBefore.Value = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv4.chkAfter.Value = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv4.chkManually.Value = Mid(sEntry, iStart, iPos - iStart)
        
        iStart = iPos + 1
        iPos = InStr(iStart, sEntry, "|")
        frmSetPBAdv4.chkWait.Value = Mid(sEntry, iStart, iPos - iStart)
    End If
End Sub

Public Sub IPServerAssigned()
    frmSetPBAdv2.optServerAssigned.Value = True
    frmSetPBAdv2.txtIPAddress1.Enabled = False
    frmSetPBAdv2.txtIPAddress2.Enabled = False
    frmSetPBAdv2.txtIPAddress3.Enabled = False
    frmSetPBAdv2.txtIPAddress4.Enabled = False
End Sub

Public Sub IPSpecific()
    frmSetPBAdv2.optSpecific.Value = True
    frmSetPBAdv2.txtIPAddress1.Enabled = True
    frmSetPBAdv2.txtIPAddress2.Enabled = True
    frmSetPBAdv2.txtIPAddress3.Enabled = True
    frmSetPBAdv2.txtIPAddress4.Enabled = True
End Sub

Public Sub NameServerAssigned()
    frmSetPBAdv3.optServerAssigned.Value = True
    frmSetPBAdv3.txtDNSAddress1.Enabled = False
    frmSetPBAdv3.txtDNSAddress2.Enabled = False
    frmSetPBAdv3.txtDNSAddress3.Enabled = False
    frmSetPBAdv3.txtDNSAddress4.Enabled = False
    frmSetPBAdv3.txtAltDNSAddress1.Enabled = False
    frmSetPBAdv3.txtAltDNSAddress2.Enabled = False
    frmSetPBAdv3.txtAltDNSAddress3.Enabled = False
    frmSetPBAdv3.txtAltDNSAddress4.Enabled = False
    frmSetPBAdv3.txtWINSAddress1.Enabled = False
    frmSetPBAdv3.txtWINSAddress2.Enabled = False
    frmSetPBAdv3.txtWINSAddress3.Enabled = False
    frmSetPBAdv3.txtWINSAddress4.Enabled = False
    frmSetPBAdv3.txtAltWINSAddress1.Enabled = False
    frmSetPBAdv3.txtAltWINSAddress2.Enabled = False
    frmSetPBAdv3.txtAltWINSAddress3.Enabled = False
    frmSetPBAdv3.txtAltWINSAddress4.Enabled = False
End Sub

Public Sub NameSpecific()
    frmSetPBAdv3.optSpecific.Value = True
    frmSetPBAdv3.txtDNSAddress1.Enabled = True
    frmSetPBAdv3.txtDNSAddress2.Enabled = True
    frmSetPBAdv3.txtDNSAddress3.Enabled = True
    frmSetPBAdv3.txtDNSAddress4.Enabled = True
    frmSetPBAdv3.txtAltDNSAddress1.Enabled = True
    frmSetPBAdv3.txtAltDNSAddress2.Enabled = True
    frmSetPBAdv3.txtAltDNSAddress3.Enabled = True
    frmSetPBAdv3.txtAltDNSAddress4.Enabled = True
    frmSetPBAdv3.txtWINSAddress1.Enabled = True
    frmSetPBAdv3.txtWINSAddress2.Enabled = True
    frmSetPBAdv3.txtWINSAddress3.Enabled = True
    frmSetPBAdv3.txtWINSAddress4.Enabled = True
    frmSetPBAdv3.txtAltWINSAddress1.Enabled = True
    frmSetPBAdv3.txtAltWINSAddress2.Enabled = True
    frmSetPBAdv3.txtAltWINSAddress3.Enabled = True
    frmSetPBAdv3.txtAltWINSAddress4.Enabled = True
End Sub


