Attribute VB_Name = "modRAS"
Option Explicit

Declare Function sRASDial Lib "SapphireRAS.dll" (ByVal sEntryName As String, ByVal sUsername As String, ByVal sPassword As String, ByVal sDomain As String, hRasConn As Long, hDC As Long, ByVal lLicence As Long) As Long
Declare Function sRASDialOnly Lib "SapphireRAS.dll" (ByVal sEntryName As String, ByVal sUsername As String, ByVal sPassword As String, ByVal sDomain As String, hRasConn As Long, ByVal lLicence As Long) As Long
Declare Function sRASGetParams Lib "SapphireRAS.dll" (ByVal sEntryName As String, ByVal sRASNames As String) As Long
Declare Function sRASSetParams Lib "SapphireRAS.dll" (ByVal sEntryName As String, ByVal sUsername As String, ByVal sPassword As String, ByVal sDomain As String) As Long
Declare Function sRASHangUp Lib "SapphireRAS.dll" (ByVal hRasConn As Long) As Long
Declare Function sRASCurrentConn Lib "SapphireRAS.dll" (ByRef hRasConn As Long, ByVal sConnName As String) As Long
Declare Function sRASStatus Lib "SapphireRAS.dll" (ByVal hRasConn As Long) As Long
Declare Function sRASStatusMsg Lib "SapphireRAS.dll" (ByVal sStatusText As String, ByVal lStatus As Long) As Long
Declare Function sRASErrMsg Lib "SapphireRAS.dll" (ByVal sErrorText As String, ByVal lError As Long) As Long
Declare Function sRASAutoDial Lib "SapphireRAS.dll" (ByRef hRasConn As Long, ByVal lLicence As Long) As Long
Declare Function sRASAutoHangup Lib "SapphireRAS.dll" (ByVal hRasConn As Long) As Long
    
' Dial Settings
Public sConnectionEntry As String
Public sUsername As String
Public sPassword As String
Public sDomain As String
Public sUserPass As Boolean
' RAS Settings
Public sEntries(50) As String
Public sDevices(50) As String

Public lConnection As Long ' Global Connection Handle, Passed Back to Disconnection and Status
Public lRASConn As Long ' Global Connection Handle, Passed Back to Disconnection and Status

Public Function RASDial(hDC As Long) As Long
    RASDial = sRASDial(sConnectionEntry, sUsername, sPassword, sDomain, lConnection, hDC, SapphireRASLicence)
    ' Set sConnectionEntry equal to your dial-up connection name
    ' Set SapphireRASLicence with your Licence Number unless Demo DLL
    ' hDC is passed into this function from the current forms Window handle
End Function

Public Function RASDialOnly() As Long
    RASDialOnly = sRASDialOnly(sConnectionEntry, sUsername, sPassword, sDomain, lConnection, SapphireRASLicence)
    ' Set sConnectionEntry equal to your dial-up connection name
    ' Set SapphireRASLicence with your Licence Number unless Demo DLL
End Function

Public Function RASGetParams(sRASEntry As String) As String
    Dim sRASNames As String
    Dim lReturn As Long
    
    sRASNames = Space(1024)
    lReturn = sRASGetParams(sRASEntry, sRASNames)
    RASGetParams = StripString(sRASNames)
End Function

Public Function RASSetParams(sRASEntry As String, sRASUsername As String, sRASPassword As String, sRASDomain As String) As Long
    RASSetParams = sRASSetParams(sRASEntry, sRASUsername, sRASPassword, sRASDomain)
End Function

Public Function RASHangUp() As Long
    RASHangUp = sRASHangUp(lConnection)
End Function

Public Function RASStatus() As Long
    RASStatus = sRASStatus(lConnection)
End Function

Public Function RASStatusMsg(lStatus As Long) As String
    Dim sStatusText As String
    Dim lReturn As Long
    
    sStatusText = Space(1024)
    lReturn = sRASStatusMsg(sStatusText, lStatus)
    RASStatusMsg = StripString(sStatusText)
End Function

Public Function RASErrMsg(lError As Long) As String
    Dim sErrorText As String
    Dim lReturn As Long
    
    sErrorText = Space(1024)
    lReturn = sRASErrMsg(sErrorText, lError)
    RASErrMsg = StripString(sErrorText)
End Function

Public Function RASCurrentConn() As String
    Dim sConnName As String
    Dim lReturn As Long
    
    sConnName = Space(40)
    lReturn = sRASCurrentConn(lConnection, sConnName)
    RASCurrentConn = StripString(sConnName)
End Function

Public Function RASAutoDial() As Long
    RASAutoDial = sRASAutoDial(lRASConn, SapphireRASLicence)
End Function

Public Function RASAutoHangup() As Long
    RASAutoHangup = sRASAutoHangup(lRASConn)
    RASCurrentConn
    RASHangUp
End Function
