using System;
using System.IO;
using System.Threading; 
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace SIMDemo
{
	/// <summary>
	/// Summary description for clsRAS.
	/// </summary>
	public class clsSim
	{
		public const int SapphireSIMLicence = 1234567890;
		public static string sPIN = "0355"; 
		public static string sPIN2 = "200157"; 

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMMakeCall(string sPhoneNumber, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMListPhoneNumbers(ref int cEntries, int iLocation, string sPhoneNames, string sPhoneNumbers, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMReadSIMLock(ref int iSet, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMReadFixedLock(ref int iSet, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMSetSIMLock(string sPassword, int iEnabled, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMSetFixedLock(string sPassword, int iEnabled, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMUnlockPIN(string sPIN, string sPIN2, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMChangeSIMPIN(string sOldPIN, string sNewPIN, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMChangeFixedPIN(string sOldPIN, string sNewPIN, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMReadPhoneNumber(int iIndex, int iLocation, string sPhoneName, string sPhoneNumber, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMWritePhoneNumber(int iIndex, int iLocation, string sPhoneName, string sPhoneNumber, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMDeletePhoneNumber(int iIndex, int iLocation, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMCheckPhone(string sState, ref int iError, int iLicence);

		[DllImport("SapphireSIM.dll")] 
		public static extern void sSIMErrorMessage(string sMessage, int iError);

		public static void MakeCall(string sPhoneNumber) 
		{ 
			sSIMMakeCall(sPhoneNumber, SapphireSIMLicence); 
		} 

		public static void ListPhoneNumbers(ref int iEntries, int iLocation, ref string sPhoneNames, ref string sPhoneNumbers) 
		{ 
			string sListPhoneNames = new String(' ',1024);
			string sListPhoneNumbers = new String(' ',1024);
			int iError = 0; 
			string sMessage = new String(' ',1024);

			sSIMListPhoneNumbers(ref iEntries, iLocation, sListPhoneNames, sListPhoneNumbers, ref iError, SapphireSIMLicence); 
			sPhoneNames = sListPhoneNames.TrimEnd(' ');
			sPhoneNames = sPhoneNames.TrimEnd(Convert.ToChar(0x0000));
			sPhoneNumbers = sListPhoneNumbers.TrimEnd(' ');
			sPhoneNumbers = sPhoneNumbers.TrimEnd(Convert.ToChar(0x0000));
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void ReadSIMLock(ref int iSet) 
		{ 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			sSIMReadSIMLock(ref iSet, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void ReadFixedLock(ref int iSet) 
		{ 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			sSIMReadFixedLock(ref iSet, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void SetSIMLock(string sPassword, bool bEnabled) 
		{ 
			int iEnabled; 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			if (bEnabled) 
				iEnabled = 1; 
			else 
				iEnabled = 0; 
			sSIMSetSIMLock(sPassword, iEnabled, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void SetFixedLock(string sPassword, bool bEnabled) 
		{ 
			int iEnabled; 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			if (bEnabled) 
				iEnabled = 1; 
			else 
				iEnabled = 0; 
			sSIMSetFixedLock(sPassword, iEnabled, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void UnlockPIN(string sPIN, string sPIN2) 
		{ 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			sSIMUnlockPIN(sPIN, sPIN2, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void ChangeSIMPIN(string sOldPIN, string sNewPIN) 
		{ 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			sSIMChangeSIMPIN(sOldPIN, sNewPIN, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void ChangeFixedPIN(string sOldPIN, string sNewPIN) 
		{ 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			sSIMChangeFixedPIN(sOldPIN, sNewPIN, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void ReadPhoneNumber(int iIndex, int iLocation, ref string sPhoneName, ref string sPhoneNumber) 
		{ 
			string sSIMPhoneName = new String(' ',100); 
			string sSIMPhoneNumber = new String(' ',100);
			int iError = 0; 
			string sMessage = new String(' ',1024);
			sSIMReadPhoneNumber(iIndex, iLocation, sSIMPhoneName, sSIMPhoneNumber, ref iError, SapphireSIMLicence); 
			sPhoneName = sSIMPhoneName.TrimEnd(' ');
			sPhoneName = sPhoneName.TrimEnd(Convert.ToChar(0x0000));
			sPhoneNumber = sSIMPhoneNumber.TrimEnd(' ');
			sPhoneNumber = sPhoneNumber.TrimEnd(Convert.ToChar(0x0000));
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void WritePhoneNumber(int iIndex, int iLocation, string sPhoneName, string sPhoneNumber) 
		{ 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			UnlockPIN(sPIN2, ""); 
			sSIMWritePhoneNumber(iIndex, iLocation, sPhoneName, sPhoneNumber, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void DeletePhoneNumber(int iIndex, int iLocation) 
		{ 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			UnlockPIN(sPIN2, ""); 
			sSIMDeletePhoneNumber(iIndex, iLocation, ref iError, SapphireSIMLicence); 
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static void CheckPhone(ref string sState) 
		{ 
			string sSIMState = new String(' ',100); 
			int iError = 0; 
			string sMessage = new String(' ',1024);
			sSIMCheckPhone(sSIMState, ref iError, SapphireSIMLicence); 
			sState = sSIMState.TrimEnd(' ');
			sState = sState.TrimEnd(Convert.ToChar(0x0000));
			if (iError != 0) 
			{ 
				sSIMErrorMessage(sMessage, iError); 
				sMessage = sMessage.TrimEnd(' ');
				sMessage = sMessage.TrimEnd(Convert.ToChar(0x0000));
				MessageBox.Show(sMessage, "SimDemo"); 
			} 
		} 

		public static string MakeLen(string sSource, int iLength) 
		{ 
			string sDest; 
			int iCount = 0; 
			if (sSource.Length >= iLength) 
			{ 
				sDest = sSource.Substring(0, iLength); 
			} 
			else 
			{ 
				sDest = sSource; 
				for (iCount = sSource.Length; iCount <= iLength - 1; iCount++) 
					sDest = sDest + " "; 
			} 
			return sDest; 
		} 
	}
}
 