using System;
using System.IO;
using System.Reflection;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace SIMDemo
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button cmdPins;
		internal System.Windows.Forms.Button cmdCall;
		internal System.Windows.Forms.CheckBox chkFixed;
		internal System.Windows.Forms.CheckBox chkSIM;
		internal System.Windows.Forms.Button cmdState;
		internal System.Windows.Forms.Button cmdUpdate;
		internal System.Windows.Forms.Button cmdAdd;
		internal System.Windows.Forms.TextBox txtNumber;
		internal System.Windows.Forms.TextBox txtName;
		internal System.Windows.Forms.Label lblNumber;
		internal System.Windows.Forms.Label lblName;
		internal System.Windows.Forms.Button cmdDelete;
		internal System.Windows.Forms.Button cmdExit;
		internal System.Windows.Forms.Label lblLocation;
		internal System.Windows.Forms.MainMenu MainMenu1;
		internal System.Windows.Forms.ComboBox cboLocation;
		internal System.Windows.Forms.ListBox lstPhoneNumbers;
		internal System.Windows.Forms.Label lblPhone;
	
		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		static void Main() 
		{
			try
			{
				Application.Run(new frmMain());
			}											
			catch
			{
			}
		}


		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.cmdPins = new System.Windows.Forms.Button();
			this.cmdCall = new System.Windows.Forms.Button();
			this.chkFixed = new System.Windows.Forms.CheckBox();
			this.chkSIM = new System.Windows.Forms.CheckBox();
			this.cmdState = new System.Windows.Forms.Button();
			this.cmdUpdate = new System.Windows.Forms.Button();
			this.cmdAdd = new System.Windows.Forms.Button();
			this.txtNumber = new System.Windows.Forms.TextBox();
			this.txtName = new System.Windows.Forms.TextBox();
			this.lblNumber = new System.Windows.Forms.Label();
			this.lblName = new System.Windows.Forms.Label();
			this.cmdDelete = new System.Windows.Forms.Button();
			this.cmdExit = new System.Windows.Forms.Button();
			this.lblLocation = new System.Windows.Forms.Label();
			this.MainMenu1 = new System.Windows.Forms.MainMenu();
			this.cboLocation = new System.Windows.Forms.ComboBox();
			this.lstPhoneNumbers = new System.Windows.Forms.ListBox();
			this.lblPhone = new System.Windows.Forms.Label();
			// 
			// cmdPins
			// 
			this.cmdPins.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			this.cmdPins.Location = new System.Drawing.Point(184, 36);
			this.cmdPins.Size = new System.Drawing.Size(48, 24);
			this.cmdPins.Text = "PINs";
			this.cmdPins.Click += new System.EventHandler(this.cmdPins_Click);
			// 
			// cmdCall
			// 
			this.cmdCall.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			this.cmdCall.Location = new System.Drawing.Point(184, 64);
			this.cmdCall.Size = new System.Drawing.Size(48, 24);
			this.cmdCall.Text = "Call";
			this.cmdCall.Click += new System.EventHandler(this.cmdCall_Click);
			// 
			// chkFixed
			// 
			this.chkFixed.Location = new System.Drawing.Point(136, 216);
			this.chkFixed.Size = new System.Drawing.Size(96, 16);
			this.chkFixed.Text = "Fixed Locked";
			this.chkFixed.CheckStateChanged += new System.EventHandler(this.chkFixed_CheckStateChanged);
			// 
			// chkSIM
			// 
			this.chkSIM.Location = new System.Drawing.Point(16, 216);
			this.chkSIM.Size = new System.Drawing.Size(88, 16);
			this.chkSIM.Text = "SIM Locked";
			this.chkSIM.CheckStateChanged += new System.EventHandler(this.chkSIM_CheckStateChanged);
			// 
			// cmdState
			// 
			this.cmdState.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			this.cmdState.Location = new System.Drawing.Point(184, 8);
			this.cmdState.Size = new System.Drawing.Size(48, 24);
			this.cmdState.Text = "State";
			this.cmdState.Click += new System.EventHandler(this.cmdState_Click);
			// 
			// cmdUpdate
			// 
			this.cmdUpdate.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			this.cmdUpdate.Location = new System.Drawing.Point(120, 240);
			this.cmdUpdate.Size = new System.Drawing.Size(56, 24);
			this.cmdUpdate.Text = "Update";
			this.cmdUpdate.Click += new System.EventHandler(this.cmdUpdate_Click);
			// 
			// cmdAdd
			// 
			this.cmdAdd.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			this.cmdAdd.Location = new System.Drawing.Point(64, 240);
			this.cmdAdd.Size = new System.Drawing.Size(48, 24);
			this.cmdAdd.Text = "Add";
			this.cmdAdd.Click += new System.EventHandler(this.cmdAdd_Click);
			// 
			// txtNumber
			// 
			this.txtNumber.Location = new System.Drawing.Point(64, 56);
			this.txtNumber.Size = new System.Drawing.Size(112, 20);
			this.txtNumber.Text = "";
			// 
			// txtName
			// 
			this.txtName.Location = new System.Drawing.Point(64, 32);
			this.txtName.Size = new System.Drawing.Size(112, 20);
			this.txtName.Text = "";
			// 
			// lblNumber
			// 
			this.lblNumber.Location = new System.Drawing.Point(8, 56);
			this.lblNumber.Size = new System.Drawing.Size(56, 16);
			this.lblNumber.Text = "Number :";
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 32);
			this.lblName.Size = new System.Drawing.Size(56, 16);
			this.lblName.Text = "Name :";
			// 
			// cmdDelete
			// 
			this.cmdDelete.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			this.cmdDelete.Location = new System.Drawing.Point(184, 240);
			this.cmdDelete.Size = new System.Drawing.Size(48, 24);
			this.cmdDelete.Text = "Delete";
			this.cmdDelete.Click += new System.EventHandler(this.cmdDelete_Click);
			// 
			// cmdExit
			// 
			this.cmdExit.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			this.cmdExit.Location = new System.Drawing.Point(8, 240);
			this.cmdExit.Size = new System.Drawing.Size(48, 24);
			this.cmdExit.Text = "Exit";
			this.cmdExit.Click += new System.EventHandler(this.cmdExit_Click);
			// 
			// lblLocation
			// 
			this.lblLocation.Location = new System.Drawing.Point(8, 8);
			this.lblLocation.Size = new System.Drawing.Size(48, 16);
			this.lblLocation.Text = "Location";
			// 
			// cboLocation
			// 
			this.cboLocation.Items.Add("General SIM");
			this.cboLocation.Items.Add("Emergency");
			this.cboLocation.Items.Add("Fixed Dialing");
			this.cboLocation.Items.Add("Last Dialing");
			this.cboLocation.Items.Add("Own Numbers");
			this.cboLocation.Location = new System.Drawing.Point(64, 8);
			this.cboLocation.Size = new System.Drawing.Size(112, 21);
			this.cboLocation.SelectedIndexChanged += new System.EventHandler(this.cboLocation_SelectedIndexChanged);
			// 
			// lstPhoneNumbers
			// 
			this.lstPhoneNumbers.Font = new System.Drawing.Font("Courier New", 8.25F, System.Drawing.FontStyle.Regular);
			this.lstPhoneNumbers.Location = new System.Drawing.Point(8, 96);
			this.lstPhoneNumbers.Size = new System.Drawing.Size(224, 114);
			this.lstPhoneNumbers.SelectedIndexChanged += new System.EventHandler(this.lstPhoneNumbers_SelectedIndexChanged);
			// 
			// lblPhone
			// 
			this.lblPhone.Location = new System.Drawing.Point(8, 80);
			this.lblPhone.Size = new System.Drawing.Size(224, 16);
			this.lblPhone.Text = "Phone Name              Number";
			// 
			// frmMain
			// 
			this.BackColor = System.Drawing.Color.Aqua;
			this.Controls.Add(this.cmdCall);
			this.Controls.Add(this.chkFixed);
			this.Controls.Add(this.chkSIM);
			this.Controls.Add(this.cmdState);
			this.Controls.Add(this.cmdUpdate);
			this.Controls.Add(this.cmdAdd);
			this.Controls.Add(this.txtNumber);
			this.Controls.Add(this.txtName);
			this.Controls.Add(this.lblNumber);
			this.Controls.Add(this.lblName);
			this.Controls.Add(this.cmdDelete);
			this.Controls.Add(this.cmdExit);
			this.Controls.Add(this.lblLocation);
			this.Controls.Add(this.cboLocation);
			this.Controls.Add(this.lstPhoneNumbers);
			this.Controls.Add(this.lblPhone);
			this.Controls.Add(this.cmdPins);
			this.Menu = this.MainMenu1;
			this.Text = "SIMDemo";
			this.Load += new System.EventHandler(this.frmMain_Load);

		}
		#endregion

		private void frmMain_Load(object sender, System.EventArgs e)
		{
			int iSet = 0; 
			FileInfo fsSim = new FileInfo(Path.GetDirectoryName(Assembly.GetExecutingAssembly().GetModules()[0].FullyQualifiedName) + "\\SapphireSim.DLL");
			if (fsSim.Exists == false) 
			{ 
				cmdAdd.Enabled = false; 
				cmdUpdate.Enabled = false; 
				cmdDelete.Enabled = false; 
				lblPhone.Text = "SapphireSim.DLL missing"; 
				lblPhone.Update(); 
			}

			cboLocation.SelectedIndex = 0; 
			UpdateList(); 
			clsSim.ReadSIMLock(ref iSet); 
			if (iSet == 1) 
			{ 
				chkSIM.CheckState = CheckState.Checked; 
			} 
			else 
			{ 
				chkSIM.CheckState = CheckState.Unchecked; 
			} 
			clsSim.ReadFixedLock(ref iSet); 
			if (iSet == 1) 
			{ 
				chkFixed.CheckState = CheckState.Checked; 
			} 
			else 
			{ 
				chkFixed.CheckState = CheckState.Unchecked; 
			} 
		}

		private void lstPhoneNumbers_SelectedIndexChanged(object sender, System.EventArgs e) 
		{ 
			string sPhoneName = ""; 
			string sPhoneNumber = ""; 
			if (lstPhoneNumbers.SelectedIndex != -1 & cboLocation.SelectedIndex != -1) 
			{ 
				clsSim.ReadPhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex, ref sPhoneName, ref sPhoneNumber); 
				txtName.Text = sPhoneName; 
				txtNumber.Text = sPhoneNumber; 
			} 
		} 

		private void cmdExit_Click(object sender, System.EventArgs e) 
		{ 
			Application.Exit(); 
		} 

		private void cboLocation_SelectedIndexChanged(object sender, System.EventArgs e) 
		{ 
			UpdateList(); 
		} 

		private void cmdAdd_Click(object sender, System.EventArgs e) 
		{ 
			if (cboLocation.SelectedIndex != -1) 
			{ 
				clsSim.WritePhoneNumber(0, cboLocation.SelectedIndex, txtName.Text, txtNumber.Text); 
			} 
			UpdateList(); 
		} 

		private void cmdUpdate_Click(object sender, System.EventArgs e) 
		{ 
			if (lstPhoneNumbers.SelectedIndex != -1 & cboLocation.SelectedIndex != -1) 
			{ 
				if (MessageBox.Show("Are you sure?", "Update", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes) 
				{ 
					clsSim.WritePhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex, txtName.Text, txtNumber.Text); 
				} 
			} 
			UpdateList(); 
		} 

		private void cmdDelete_Click(object sender, System.EventArgs e) 
		{ 
			if (lstPhoneNumbers.SelectedIndex != -1 & cboLocation.SelectedIndex != -1) 
			{ 
				if (MessageBox.Show("Are you sure?", "Delete", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes) 
				{ 
					clsSim.DeletePhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex); 
				} 
			} 
			UpdateList(); 
		} 

		private void UpdateList() 
		{ 
			int iCount; 
			int iEntries; 
			string sPhoneNames = ""; 
			string sPhoneNumbers = ""; 
			lstPhoneNumbers.Items.Clear(); 
			iEntries = 0; 
			if (cboLocation.SelectedIndex != -1) 
			{ 
				clsSim.ListPhoneNumbers(ref iEntries, cboLocation.SelectedIndex, ref sPhoneNames, ref sPhoneNumbers); 
				string [] sListPhoneNames = sPhoneNames.Split('|');
				string [] sListPhoneNumbers = sPhoneNumbers.Split('|');

				clsListItem [] oComboPhoneNumber = new clsListItem[iEntries + 1];
				for (iCount = 0; iCount <= iEntries - 1; iCount++) 
				{ 
					oComboPhoneNumber[iCount] = new clsListItem();
					oComboPhoneNumber[iCount].iValue = iCount;
					oComboPhoneNumber[iCount].sText = clsSim.MakeLen(sListPhoneNames[iCount], 18) + sListPhoneNumbers[iCount];
					//clsMain.fSetPB.cboDevice.Items.Add(oComboDevice[iCount]);
					lstPhoneNumbers.Items.Add(oComboPhoneNumber[iCount]);

					//lstPhoneNumbers.Items.Add(New clsListItem(clsSim.MakeLen(sListPhoneNames[iCount], 18) + sListPhoneNumbers[iCount], iCount)); 
				} 
			} 
		} 

		private void cmdState_Click(object sender, System.EventArgs e) 
		{ 
			string sState = ""; 
			string sPUK = ""; 
			string sPUK2 = ""; 
			clsSim.CheckPhone(ref sState); 
			MessageBox.Show(sState, "SIMDemo");
			if (sState != "Ready") 
			{ 
				if (MessageBox.Show("Is a PUK2 code required?", "PUK2", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes) 
				{ 
					sPUK2 = Microsoft.VisualBasic.Interaction.InputBox("Enter PUK2 Number", "PUK2", "",10,10);
					clsSim.sPIN2 = Microsoft.VisualBasic.Interaction.InputBox("Enter a new PIN2 Number", "PIN2", clsSim.sPIN2,10,10);
					clsSim.UnlockPIN(sPUK2, clsSim.sPIN2); 
				} 
				if (MessageBox.Show("Is a PUK code required?", "PUK", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes) 
				{ 
					sPUK = Microsoft.VisualBasic.Interaction.InputBox("Enter PUK Number", "PUK", "",10,10);
					clsSim.sPIN = Microsoft.VisualBasic.Interaction.InputBox("Enter a new PIN Number", "PIN", clsSim.sPIN,10,10);
					clsSim.UnlockPIN(sPUK, clsSim.sPIN); 
				} 
			} 
		} 

		private void chkSIM_CheckStateChanged(object sender, System.EventArgs e) 
		{ 
			if (chkSIM.CheckState == CheckState.Checked) 
			{ 
				clsSim.SetSIMLock(clsSim.sPIN, true); 
			} 
			else 
			{ 
				clsSim.SetSIMLock(clsSim.sPIN, false); 
			} 
		} 

		private void chkFixed_CheckStateChanged(object sender, System.EventArgs e) 
		{ 
			if (chkFixed.CheckState == CheckState.Checked) 
			{ 
				clsSim.SetFixedLock(clsSim.sPIN, true); 
			} 
			else 
			{ 
				clsSim.SetFixedLock(clsSim.sPIN2, false); 
			} 
		} 

		private void cmdPIN_Click(object sender, System.EventArgs e) 
		{ 
			string sOldPIN; 
			string sNewPIN; 
			if (MessageBox.Show("Do you want to change the PIN number?", "PIN", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)
			{ 
				sOldPIN = Microsoft.VisualBasic.Interaction.InputBox("Enter Old PIN Number", "PIN", clsSim.sPIN,10,10);
				sNewPIN = Microsoft.VisualBasic.Interaction.InputBox("Enter New PIN Number", "PIN", "",10,10);
				if (Microsoft.VisualBasic.Information.IsNumeric(sOldPIN) == true & Microsoft.VisualBasic.Information.IsNumeric(sNewPIN) == true) 
				{ 
					clsSim.ChangeSIMPIN(sOldPIN, sNewPIN); 
					clsSim.sPIN = sNewPIN; 
				} 
			} 
		} 

		private void cmdPIN2_Click(object sender, System.EventArgs e) 
		{ 
			string sOldPIN; 
			string sNewPIN; 
			if (MessageBox.Show("Do you want to change the PIN2 number?", "PIN2", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) == DialogResult.Yes)
			{ 
				sOldPIN = Microsoft.VisualBasic.Interaction.InputBox("Enter Old PIN2 Number", "PIN2", clsSim.sPIN2,10,10);
				sNewPIN = Microsoft.VisualBasic.Interaction.InputBox("Enter New PIN2 Number", "PIN2", "",10,10);
				if (Microsoft.VisualBasic.Information.IsNumeric(sOldPIN) == true & Microsoft.VisualBasic.Information.IsNumeric(sNewPIN) == true) 
				{ 
					clsSim.ChangeFixedPIN(sOldPIN, sNewPIN); 
					clsSim.sPIN2 = sNewPIN; 
				} 
			} 
		} 

		private void cmdCall_Click(object sender, System.EventArgs e) 
		{ 
			string sPhoneName = ""; 
			string sPhoneNumber = ""; 
			if (lstPhoneNumbers.SelectedIndex != -1 & cboLocation.SelectedIndex != -1) 
			{ 
				clsSim.ReadPhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex, ref sPhoneName, ref sPhoneNumber); 
				clsSim.MakeCall(sPhoneNumber); 
			} 
		} 

		private void cmdPins_Click(object sender, System.EventArgs e) 
		{ 
			string sNewPIN = ""; 
			sNewPIN = Microsoft.VisualBasic.Interaction.InputBox("Enter PIN Number", "PIN", clsSim.sPIN,10,10);
			if (sNewPIN != "") 
			{ 
				clsSim.sPIN = sNewPIN; 
			} 
			sNewPIN = Microsoft.VisualBasic.Interaction.InputBox("Enter PIN2 Number", "PIN2", clsSim.sPIN2,10,10);
			if (sNewPIN != "") 
			{ 
				clsSim.sPIN2 = sNewPIN; 
			} 
		}
	}
}
