Imports System.IO
Imports System.Reflection

Public Class frmMain
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        MyBase.Dispose(disposing)
    End Sub

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents cmdExit As System.Windows.Forms.Button
    Friend WithEvents lblLocation As System.Windows.Forms.Label
    Friend WithEvents cboLocation As System.Windows.Forms.ComboBox
    Friend WithEvents lstPhoneNumbers As System.Windows.Forms.ListBox
    Friend WithEvents lblName As System.Windows.Forms.Label
    Friend WithEvents lblNumber As System.Windows.Forms.Label
    Friend WithEvents txtName As System.Windows.Forms.TextBox
    Friend WithEvents txtNumber As System.Windows.Forms.TextBox
    Friend WithEvents cmdDelete As System.Windows.Forms.Button
    Friend WithEvents cmdAdd As System.Windows.Forms.Button
    Friend WithEvents cmdUpdate As System.Windows.Forms.Button
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
    Friend WithEvents lblPhone As System.Windows.Forms.Label
    Friend WithEvents cmdState As System.Windows.Forms.Button
    Friend WithEvents chkSIM As System.Windows.Forms.CheckBox
    Friend WithEvents chkFixed As System.Windows.Forms.CheckBox
    Friend WithEvents cmdCall As System.Windows.Forms.Button
    Friend WithEvents cmdPins As System.Windows.Forms.Button
    Private Sub InitializeComponent()
        Me.cmdDelete = New System.Windows.Forms.Button
        Me.cmdExit = New System.Windows.Forms.Button
        Me.lblLocation = New System.Windows.Forms.Label
        Me.cboLocation = New System.Windows.Forms.ComboBox
        Me.lstPhoneNumbers = New System.Windows.Forms.ListBox
        Me.lblPhone = New System.Windows.Forms.Label
        Me.lblName = New System.Windows.Forms.Label
        Me.lblNumber = New System.Windows.Forms.Label
        Me.txtName = New System.Windows.Forms.TextBox
        Me.txtNumber = New System.Windows.Forms.TextBox
        Me.cmdAdd = New System.Windows.Forms.Button
        Me.cmdUpdate = New System.Windows.Forms.Button
        Me.MainMenu1 = New System.Windows.Forms.MainMenu
        Me.cmdState = New System.Windows.Forms.Button
        Me.chkSIM = New System.Windows.Forms.CheckBox
        Me.chkFixed = New System.Windows.Forms.CheckBox
        Me.cmdCall = New System.Windows.Forms.Button
        Me.cmdPins = New System.Windows.Forms.Button
        '
        'cmdDelete
        '
        Me.cmdDelete.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.cmdDelete.Location = New System.Drawing.Point(184, 240)
        Me.cmdDelete.Size = New System.Drawing.Size(48, 24)
        Me.cmdDelete.Text = "Delete"
        '
        'cmdExit
        '
        Me.cmdExit.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.cmdExit.Location = New System.Drawing.Point(8, 240)
        Me.cmdExit.Size = New System.Drawing.Size(48, 24)
        Me.cmdExit.Text = "Exit"
        '
        'lblLocation
        '
        Me.lblLocation.Location = New System.Drawing.Point(8, 8)
        Me.lblLocation.Size = New System.Drawing.Size(48, 16)
        Me.lblLocation.Text = "Location"
        '
        'cboLocation
        '
        Me.cboLocation.Items.Add("General SIM")
        Me.cboLocation.Items.Add("Emergency")
        Me.cboLocation.Items.Add("Fixed Dialing")
        Me.cboLocation.Items.Add("Last Dialing")
        Me.cboLocation.Items.Add("Own Numbers")
        Me.cboLocation.Location = New System.Drawing.Point(64, 8)
        Me.cboLocation.Size = New System.Drawing.Size(112, 21)
        '
        'lstPhoneNumbers
        '
        Me.lstPhoneNumbers.Font = New System.Drawing.Font("Courier New", 8.25!, System.Drawing.FontStyle.Regular)
        Me.lstPhoneNumbers.Location = New System.Drawing.Point(8, 96)
        Me.lstPhoneNumbers.Size = New System.Drawing.Size(224, 114)
        '
        'lblPhone
        '
        Me.lblPhone.Location = New System.Drawing.Point(8, 80)
        Me.lblPhone.Size = New System.Drawing.Size(224, 16)
        Me.lblPhone.Text = "Phone Name              Number"
        '
        'lblName
        '
        Me.lblName.Location = New System.Drawing.Point(8, 32)
        Me.lblName.Size = New System.Drawing.Size(56, 16)
        Me.lblName.Text = "Name :"
        '
        'lblNumber
        '
        Me.lblNumber.Location = New System.Drawing.Point(8, 56)
        Me.lblNumber.Size = New System.Drawing.Size(56, 16)
        Me.lblNumber.Text = "Number :"
        '
        'txtName
        '
        Me.txtName.Location = New System.Drawing.Point(64, 32)
        Me.txtName.Size = New System.Drawing.Size(112, 20)
        Me.txtName.Text = ""
        '
        'txtNumber
        '
        Me.txtNumber.Location = New System.Drawing.Point(64, 56)
        Me.txtNumber.Size = New System.Drawing.Size(112, 20)
        Me.txtNumber.Text = ""
        '
        'cmdAdd
        '
        Me.cmdAdd.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.cmdAdd.Location = New System.Drawing.Point(64, 240)
        Me.cmdAdd.Size = New System.Drawing.Size(48, 24)
        Me.cmdAdd.Text = "Add"
        '
        'cmdUpdate
        '
        Me.cmdUpdate.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.cmdUpdate.Location = New System.Drawing.Point(120, 240)
        Me.cmdUpdate.Size = New System.Drawing.Size(56, 24)
        Me.cmdUpdate.Text = "Update"
        '
        'cmdState
        '
        Me.cmdState.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.cmdState.Location = New System.Drawing.Point(184, 8)
        Me.cmdState.Size = New System.Drawing.Size(48, 24)
        Me.cmdState.Text = "State"
        '
        'chkSIM
        '
        Me.chkSIM.Location = New System.Drawing.Point(16, 216)
        Me.chkSIM.Size = New System.Drawing.Size(88, 16)
        Me.chkSIM.Text = "SIM Locked"
        '
        'chkFixed
        '
        Me.chkFixed.Location = New System.Drawing.Point(136, 216)
        Me.chkFixed.Size = New System.Drawing.Size(96, 16)
        Me.chkFixed.Text = "Fixed Locked"
        '
        'cmdCall
        '
        Me.cmdCall.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.cmdCall.Location = New System.Drawing.Point(184, 64)
        Me.cmdCall.Size = New System.Drawing.Size(48, 24)
        Me.cmdCall.Text = "Call"
        '
        'cmdPins
        '
        Me.cmdPins.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Bold)
        Me.cmdPins.Location = New System.Drawing.Point(184, 36)
        Me.cmdPins.Size = New System.Drawing.Size(48, 24)
        Me.cmdPins.Text = "PINs"
        '
        'frmMain
        '
        Me.BackColor = System.Drawing.Color.Aqua
        Me.Controls.Add(Me.cmdPins)
        Me.Controls.Add(Me.cmdCall)
        Me.Controls.Add(Me.chkFixed)
        Me.Controls.Add(Me.chkSIM)
        Me.Controls.Add(Me.cmdState)
        Me.Controls.Add(Me.cmdUpdate)
        Me.Controls.Add(Me.cmdAdd)
        Me.Controls.Add(Me.txtNumber)
        Me.Controls.Add(Me.txtName)
        Me.Controls.Add(Me.lblNumber)
        Me.Controls.Add(Me.lblName)
        Me.Controls.Add(Me.cmdDelete)
        Me.Controls.Add(Me.cmdExit)
        Me.Controls.Add(Me.lblLocation)
        Me.Controls.Add(Me.cboLocation)
        Me.Controls.Add(Me.lstPhoneNumbers)
        Me.Controls.Add(Me.lblPhone)
        Me.Menu = Me.MainMenu1
        Me.Text = "Sim Demo"

    End Sub

#End Region

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim iSet As Integer

        ' Make sure the DLL(s) are in the same directory as the program for VB.NET
        Dim fsSim As New FileInfo(Path.GetDirectoryName([Assembly].GetExecutingAssembly().GetModules(0).FullyQualifiedName) & "\SapphireSim.DLL")
        If fsSim.Exists() = False Then
            cmdAdd.Enabled = False
            cmdUpdate.Enabled = False
            cmdDelete.Enabled = False
            lblPhone.Text = "SapphireSim.DLL missing"
            lblPhone.Update()
        End If
        cboLocation.SelectedIndex = 0
        UpdateList()
        ReadSIMLock(iSet)
        If iSet = 1 Then
            chkSIM.CheckState = CheckState.Checked
        Else
            chkSIM.CheckState = CheckState.Unchecked
        End If
        ReadFixedLock(iSet)
        If iSet = 1 Then
            chkFixed.CheckState = CheckState.Checked
        Else
            chkFixed.CheckState = CheckState.Unchecked
        End If
    End Sub

    Private Sub lstPhoneNumbers_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lstPhoneNumbers.SelectedIndexChanged
        Dim sPhoneName As String = ""
        Dim sPhoneNumber As String = ""

        If lstPhoneNumbers.SelectedIndex <> -1 And cboLocation.SelectedIndex <> -1 Then
            ReadPhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex, sPhoneName, sPhoneNumber)
            txtName.Text = sPhoneName
            txtNumber.Text = sPhoneNumber
        End If
    End Sub

    Private Sub cmdExit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdExit.Click
        Application.Exit()
    End Sub

    Private Sub cboLocation_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cboLocation.SelectedIndexChanged
        UpdateList()
    End Sub

    Private Sub cmdAdd_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdAdd.Click
        If cboLocation.SelectedIndex <> -1 Then
            WritePhoneNumber(0, cboLocation.SelectedIndex, txtName.Text, txtNumber.Text)
        End If
        UpdateList()
    End Sub

    Private Sub cmdUpdate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdUpdate.Click
        If lstPhoneNumbers.SelectedIndex <> -1 And cboLocation.SelectedIndex <> -1 Then
            If MessageBox.Show("Are you sure?", "Update", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) = DialogResult.Yes Then
                WritePhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex, txtName.Text, txtNumber.Text)
            End If
        End If
        UpdateList()
    End Sub

    Private Sub cmdDelete_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDelete.Click
        If lstPhoneNumbers.SelectedIndex <> -1 And cboLocation.SelectedIndex <> -1 Then
            If MessageBox.Show("Are you sure?", "Delete", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) = DialogResult.Yes Then
                DeletePhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex)
            End If
        End If
        UpdateList()
    End Sub

    Private Sub UpdateList()
        Dim iCount As Integer
        Dim iEntries As Integer
        Dim sPhoneNames As String = ""
        Dim sPhoneNumbers As String = ""

        lstPhoneNumbers.Items.Clear()
        iEntries = 0

        If cboLocation.SelectedIndex <> -1 Then
            ListPhoneNumbers(iEntries, cboLocation.SelectedIndex, sPhoneNames, sPhoneNumbers)

            Dim sListPhoneNames() As String = Split(sPhoneNames, "|", -1)
            Dim sListPhoneNumbers() As String = Split(sPhoneNumbers, "|", -1)
            For iCount = 0 To iEntries - 1
                lstPhoneNumbers.Items.Add(New ListItem(MakeLen(sListPhoneNames(iCount), 18) & sListPhoneNumbers(iCount), iCount))
            Next iCount
        End If
    End Sub

    Private Sub cmdState_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdState.Click
        Dim sState As String = ""
        Dim sPUK As String = ""
        Dim sPUK2 As String = ""

        CheckPhone(sState)
        MsgBox(sState)

        If sState <> "Ready" Then
            If MessageBox.Show("Is a PUK2 code required?", "PUK2", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) = DialogResult.Yes Then
                sPUK2 = InputBox("Enter PUK2 Number", "PUK2")
                sPIN2 = InputBox("Enter a new PIN2 Number", "PIN2", sPIN2)
                UnlockPIN(sPUK2, sPIN2)
            End If

            If MessageBox.Show("Is a PUK code required?", "PUK", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button2) = DialogResult.Yes Then
                sPUK = InputBox("Enter PUK Number", "PUK")
                sPIN = InputBox("Enter a new PIN Number", "PIN", sPIN)
                UnlockPIN(sPUK, sPIN)
            End If
        End If
    End Sub

    Private Sub chkSIM_CheckStateChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkSIM.CheckStateChanged
        If chkSIM.CheckState = CheckState.Checked Then
            SetSIMLock(sPIN, True)
        Else
            SetSIMLock(sPIN, False)
        End If
    End Sub

    Private Sub chkFixed_CheckStateChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkFixed.CheckStateChanged
        If chkFixed.CheckState = CheckState.Checked Then
            SetFixedLock(sPIN, True)
        Else
            SetFixedLock(sPIN2, False)
        End If
    End Sub

    Private Sub cmdPIN_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim sOldPIN As String
        Dim sNewPIN As String

        If MsgBox("Do you want to change the PIN number?", MsgBoxStyle.Question Or MsgBoxStyle.YesNoCancel, "PIN") = MsgBoxResult.Yes Then
            sOldPIN = InputBox("Enter Old PIN Number", "PIN", sPIN)
            sNewPIN = InputBox("Enter New PIN Number", "PIN")
            If IsNumeric(sOldPIN) = True And IsNumeric(sNewPIN) = True Then
                ChangeSIMPIN(sOldPIN, sNewPIN)
                sPIN = sNewPIN
            End If
        End If
    End Sub

    Private Sub cmdPIN2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim sOldPIN As String
        Dim sNewPIN As String

        If MsgBox("Do you want to change the PIN2 number?", MsgBoxStyle.Question Or MsgBoxStyle.YesNoCancel, "PIN2") = MsgBoxResult.Yes Then
            sOldPIN = InputBox("Enter Old PIN2 Number", "PIN2", sPIN2)
            sNewPIN = InputBox("Enter New PIN2 Number", "PIN2")
            If IsNumeric(sOldPIN) = True And IsNumeric(sNewPIN) = True Then
                ChangeFixedPIN(sOldPIN, sNewPIN)
                sPIN2 = sNewPIN
            End If
        End If
    End Sub

    Private Sub cmdCall_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCall.Click
        Dim sPhoneName As String = ""
        Dim sPhoneNumber As String = ""

        If lstPhoneNumbers.SelectedIndex <> -1 And cboLocation.SelectedIndex <> -1 Then
            ReadPhoneNumber(lstPhoneNumbers.SelectedIndex + 1, cboLocation.SelectedIndex, sPhoneName, sPhoneNumber)
            MakeCall(sPhoneNumber)
        End If
    End Sub

    Private Sub cmdPins_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdPins.Click
        Dim sNewPIN As String

        sNewPIN = InputBox("Enter PIN Number", "PIN", sPIN)
        If sNewPIN <> "" Then
            sPIN = sNewPIN
        End If

        sNewPIN = InputBox("Enter PIN2 Number", "PIN2", sPIN2)
        If sNewPIN <> "" Then
            sPIN2 = sNewPIN
        End If
    End Sub
End Class
