Imports System.Threading.Thread
Imports System.Runtime.InteropServices

Module modSim
    Public Const SapphireSIMLicence As Integer = 1234567890
    Public sPIN As String = "0355"
    Public sPIN2 As String = "200157"

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMMakeCall(ByVal sPhoneNumber As String, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMListPhoneNumbers(ByRef cEntries As Integer, ByVal iLocation As Integer, ByVal sPhoneNames As String, ByVal sPhoneNumbers As String, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMReadSIMLock(ByRef iSet As Integer, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMReadFixedLock(ByRef iSet As Integer, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMSetSIMLock(ByVal sPassword As String, ByVal iEnabled As Integer, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMSetFixedLock(ByVal sPassword As String, ByVal iEnabled As Integer, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMUnlockPIN(ByVal sPIN As String, ByVal sPIN2 As String, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMChangeSIMPIN(ByVal sOldPIN As String, ByVal sNewPIN As String, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMChangeFixedPIN(ByVal sOldPIN As String, ByVal sNewPIN As String, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMReadPhoneNumber(ByVal iIndex As Integer, ByVal iLocation As Integer, ByVal sPhoneName As String, ByVal sPhoneNumber As String, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMWritePhoneNumber(ByVal iIndex As Integer, ByVal iLocation As Integer, ByVal sPhoneName As String, ByVal sPhoneNumber As String, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMDeletePhoneNumber(ByVal iIndex As Integer, ByVal iLocation As Integer, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMCheckPhone(ByVal sState As String, ByRef iError As Integer, ByVal iLicence As Integer)
    End Sub

    <DllImport("SapphireSIM.dll")> _
    Public Sub sSIMErrorMessage(ByVal sMessage As String, ByVal iError As Integer)
    End Sub

    Public Sub MakeCall(ByVal sPhoneNumber As String)
        sSIMMakeCall(sPhoneNumber, SapphireSIMLicence)
    End Sub

    Public Sub ListPhoneNumbers(ByRef iEntries As Integer, ByVal iLocation As Integer, ByRef sPhoneNames As String, ByRef sPhoneNumbers As String)
        Dim sListPhoneNames As String
        Dim sListPhoneNumbers As String
        Dim iError As Integer
        Dim sMessage As String

        sListPhoneNames = Space(1024)
        sListPhoneNumbers = Space(1024)
        sSIMListPhoneNumbers(iEntries, iLocation, sListPhoneNames, sListPhoneNumbers, iError, SapphireSIMLicence)
        sPhoneNames = StripString(sListPhoneNames)
        sPhoneNumbers = StripString(sListPhoneNumbers)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub ReadSIMLock(ByRef iSet As Integer)
        Dim iError As Integer
        Dim sMessage As String

        sSIMReadSIMLock(iSet, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub ReadFixedLock(ByRef iSet As Integer)
        Dim iError As Integer
        Dim sMessage As String

        sSIMReadFixedLock(iSet, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub SetSIMLock(ByVal sPassword As String, ByVal bEnabled As Boolean)
        Dim iEnabled As Integer
        Dim iError As Integer
        Dim sMessage As String

        If bEnabled Then
            iEnabled = 1
        Else
            iEnabled = 0
        End If
        sSIMSetSIMLock(sPassword, iEnabled, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub SetFixedLock(ByVal sPassword As String, ByVal bEnabled As Boolean)
        Dim iEnabled As Integer
        Dim iError As Integer
        Dim sMessage As String

        If bEnabled Then
            iEnabled = 1
        Else
            iEnabled = 0
        End If
        sSIMSetFixedLock(sPassword, iEnabled, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub UnlockPIN(ByVal sPIN As String, ByVal sPIN2 As String)
        Dim iError As Integer
        Dim sMessage As String

        sSIMUnlockPIN(sPIN, sPIN2, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub ChangeSIMPIN(ByVal sOldPIN As String, ByVal sNewPIN As String)
        Dim iError As Integer
        Dim sMessage As String

        sSIMChangeSIMPIN(sOldPIN, sNewPIN, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub ChangeFixedPIN(ByVal sOldPIN As String, ByVal sNewPIN As String)
        Dim iError As Integer
        Dim sMessage As String

        sSIMChangeFixedPIN(sOldPIN, sNewPIN, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub ReadPhoneNumber(ByVal iIndex As Integer, ByVal iLocation As Integer, ByRef sPhoneName As String, ByRef sPhoneNumber As String)
        Dim sSIMPhoneName As String
        Dim sSIMPhoneNumber As String
        Dim iError As Integer
        Dim sMessage As String

        sSIMPhoneName = Space(100)
        sSIMPhoneNumber = Space(100)
        sSIMReadPhoneNumber(iIndex, iLocation, sSIMPhoneName, sSIMPhoneNumber, iError, SapphireSIMLicence)
        sPhoneName = StripString(sSIMPhoneName)
        sPhoneNumber = StripString(sSIMPhoneNumber)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub WritePhoneNumber(ByVal iIndex As Integer, ByVal iLocation As Integer, ByVal sPhoneName As String, ByVal sPhoneNumber As String)
        Dim iError As Integer
        Dim sMessage As String

        UnlockPIN(sPIN2, "")
        sSIMWritePhoneNumber(iIndex, iLocation, sPhoneName, sPhoneNumber, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub DeletePhoneNumber(ByVal iIndex As Integer, ByVal iLocation As Integer)
        Dim iError As Integer
        Dim sMessage As String

        UnlockPIN(sPIN2, "")
        sSIMDeletePhoneNumber(iIndex, iLocation, iError, SapphireSIMLicence)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Sub CheckPhone(ByRef sState As String)
        Dim sSIMState As String
        Dim iError As Integer
        Dim sMessage As String

        sSIMState = Space(100)
        sSIMCheckPhone(sSIMState, iError, SapphireSIMLicence)
        sState = StripString(sSIMState)
        If iError <> 0 Then
            sMessage = Space(1024)
            sSIMErrorMessage(sMessage, iError)
            sMessage = StripString(sMessage)
            MessageBox.Show(sMessage, "SimDemo")
        End If
    End Sub

    Public Function StripString(ByVal sSource As String) As String
        Dim iEnd As Integer

        iEnd = InStr(sSource, Chr(0))
        If iEnd > 0 Then
            StripString = Mid(sSource, 1, iEnd - 1)
        Else
            StripString = sSource
        End If
    End Function

    ' Make string to a given length
    Public Function MakeLen(ByVal sSource As String, ByVal iLength As Integer) As String
        Dim sDest As String
        Dim iCount As Integer

        If Len(sSource) >= iLength Then
            sDest = Mid(sSource, 1, iLength)
        Else
            sDest = sSource
            For iCount = Len(sSource) To iLength - 1
                sDest = sDest + " "
            Next iCount
        End If
        MakeLen = sDest
    End Function
End Module
